<?php
/**
* ʸ󥳡ǥ󥰽ϥե륿
*
* PHP version 5
*
* @package    filters
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/

class EncodingOutputFilter implements IFilter
{
	var $_config;
	var $_output_filters;

	/*
	 *    󥹥ȥ饯
	 */
	public function __construct()
	{
	}

	/*
	 * ե륿̾
	 */
	public function getFilterName()
	{
		return "Encoding Output Filter";
	}

	/*
	 * ե륿
	 */
	public function init( Config $config )
	{
	}

	/*
	 * ե륿Ԥ
	 */
	public function filter( IRequest $request, ProcedureContext $context, Response $response )
	{
		log_info( "system",  "EncodingOutputFilter¹Ԥޤ", __FILE__, __LINE__ );

		// EncodingConverter
		$conv = EncodingConverter::fromString( 'PHP_TO_HTML' );

		// responseȤ򤹤٤ƥ󥳡ǥѴ
		$keys = $response->getKeys();
		foreach( $keys as $key ){
			$value = $response->get( $key );
			if ( is_string($value) ){
				$value = $conv->convertEncoding($value);
				$response->set( $key, $value );
			}
			else if ( is_array($value) ){
				$value = $this->_convertEncodingArray( $value, $conv, 1 );
				$response->set( $key, $value );
			}
			else if ( is_object($value) ){
				$value = $this->_convertEncodingObject( $value, $conv, 1 );
				$response->set( $key, $value );
			}
		}

		foreach( $keys as $key ){
			$value = $response->get( $key );
		}

		log_info( "system",  "EncodingOutputFilter¹Ԥλޤ", __FILE__, __LINE__ );
	}

	/*
	 * ֥ȤΥ󥳡ǥѴʺƵ᥽åɡ
	 */
	private function _convertEncodingObject( $obj, EncodingConverter $conv, $level )
	{
		$vars = get_object_vars($obj);

		foreach( $vars as $key => $var ){
			if ( is_string($var) ){
				$var = $conv->convertEncoding($var);
				$obj->$key = $var;
			}
			else if ( is_array($var) ){
				$var = $this->_convertEncodingArray( $var, $conv, $level + 1 );
				$obj->$key = $var;
			}
			else if ( is_object($var) ){
				$var = $this->_convertEncodingObject( $var, $conv, $level + 1 );
				$obj->$key = $var;
			}
			else{
				$obj->$key = $var;
			}
		}

		return $obj;
	}

	/*
	 * Υ󥳡ǥѴʺƵ᥽åɡ
	 */
	private function _convertEncodingArray( $ary, EncodingConverter $conv, $level )
	{
		foreach( $ary as $key => $value ){
			if ( is_string($value) ){
				$value = $conv->convertEncoding($value);
				$ary[ $key ] = $value;
			}
			else if ( is_array($value) ){
				$value = $this->_convertEncodingArray( $value, $conv, $level + 1 );
				$ary[ $key ] = $value;
			}
			else if ( is_object($value) ){
				$value = $this->_convertEncodingObject( $value, $conv, $level + 1 );
				$ary[ $key ] = $value;
			}
			else{
				$ary[ $key ] = $value;
			}
		}

		return $ary;
	}

}

?>