<?php
/**
* ǥեȤΥơ֥ǥ
*
* PHP version 5
*
* @package    components.db
* @author     stk2k <stk2k@sazysoft.com>
* @copyright  2008 stk2k, sazysoft
*/
class DefaultTableModel implements ITableModel
{
	private $_model_id;
	private $_class_name;
	private $_class_vars;
	private $_annotations;

	/*
	 *	󥹥ȥ饯
	 */
	public function __construct()
	{
		$this->_model_id    = NULL;
		$this->_class_name  = get_class($this);
		$this->_class_vars  = get_class_vars($this->_class_name);

		$this->_annotation_list = array();
		foreach( $this->_class_vars as $key => $var ){
			$this->_annotations[$key] = AnnotationUtil::parse( $key, $var );
		}
	}

	/**
	 * ǥID
	 */
	public function setModelID( $model_id )
	{
		$this->_model_id = $model_id;
	}

	/**
	 * ǥID
	 */
	public function getModelID()
	{
		return $this->_model_id;
	}

	/*
	 *	ơ֥̾
	 */
	public function getTableName()
	{
		if ( property_exists($this,'___table_name') ){
			$table_name = $this->___table_name;
		}
		else{
			$table_name = $this->_class_name;
		}
		return $table_name;
	}

	/*
	 *   ץ饤ޥꥭե̾
	 */
	public function getPrimaryKey()
	{
		$field_list = $this->getFieldList();

		foreach( $field_list as $field ){
			$annot_map = $this->getAnnotationMap( $field );
			if ( isset($annot_map['pk']) ){
				// @pkꤵƤ鳰
				return $field;
			}
		}

		throw new TableModelException( $this, NULL, 'no primary key' );
	}

	/*
	 *   ե̾
	 */
	public function getForeignKey( $model_name )
	{
		$field_list = $this->getFieldList();

		foreach( $field_list as $field ){
			$annot_map = $this->getAnnotationMap( $field );
			if ( isset($annot_map['fk']) ){
				// @fkꤵƤ鳰
				$fk = $annot_map[ 'fk' ];
				if ( $fk->getValue() === $model_name ){
					return $field;
				}
			}
		}

		throw new TableModelException( $this, NULL, "no foreign key for:$model_name" );
	}

	/*
	 *   Ÿեɤ
	 */
	public function getExtractField( $model_name, $field )
	{
		$extract_list = $this->getExtractFieldList();

		foreach( $extract_list as $extract ){
			// @source:model_name/field򸡺
			$annot = $this->getAnnotation( $extract, 'source' );
			if ( $annot && $annot->getValue() === "$model_name/$field" ){
				return $extract;
			}
		}

		return NULL;
	}

	/*
	 *   Ϣ
	 */
	public function getRelationList()
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $field => $annot_list ){
				foreach( $annot_list as $annot ){
					// @relationꤵƤϢ
					if ( $annot && $annot->getName() === 'relation' && $annot->getValue() === NULL ){
						$result[] = $field;
					}
				}
			}
		}

		return $result;
	}

	/**
	 * եɤ¸ߤ뤫
	 */
	public function fieldExists( $field_name )
	{
		return isset($this->_class_vars[$field_name]);
	}

	/*
	 *   °
	 */
	private function getAttributeList( $name, $value )
	{
		$result = array();

		$annotations = $this->_annotations;
		if ( $annotations ){
			foreach( $annotations as $attr => $annot_list ){
				foreach( $annot_list as $annot ){
					// °ξȽ
					if ( $annot && $annot->getName() === $name && $annot->getValue() === $value ){
						$result[] = $attr;
					}
				}
			}
		}

		return $result;
	}

	/*
	 *   եɰ
	 */
	public function getFieldList()
	{
		return $this->getAttributeList( 'field', NULL );
	}
	/*
	 *   Ÿեɰ
	 */
	public function getExtractFieldList()
	{
		return $this->getAttributeList( 'extract', NULL );
	}

	/*
	 *   Υơ
	 */
	public function getAnnotation( $field, $annotation_name )
	{
		$annot_map = $this->getAnnotationMap( $field );
		if ( is_null($annot_map) || !isset($annot_map[$annotation_name]) ){
			return NULL;
		}
		return $annot_map[$annotation_name];
	}

	/*
	 *   ꤷեɤΥΥơޥåפ
	 */
	public function getAnnotationMap( $field )
	{
		if ( !isset($this->_annotations[$field]) ){
			return NULL;
		}
		return $this->_annotations[$field];
	}

	/*
	 *   Υơͤ
	 */
	public function getAnnotationValue( $field, $annotation_name, $defaultValue = NULL )
	{
		$annot = $this->getAnnotation( $field, $annotation_name );

		return $annot ? $annot->getValue() : $defaultValue;
	}

	/*
	 *   ʸ
	 */
	public function __toString()
	{
		return "[TableModel:" . get_class($this) . "]";
	}

}
