/*
==============================================================================
	zentohan.c
		1991/01/08/Tue	Yutaka MYOKI(Nagao Lab., KUEE)
		1991/01/08/Tue	Last Modified
==============================================================================
*/

#include <stdio.h>
#include <string.h>
#ifdef KOCHA2
#include "kcode.h"
#endif

#define iskanji(x) ((unsigned char)(x) & 0x80)

static char hankaku_table[] = 
"!\"#$%&()*+,-.'/0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^abcdefghijklmnopqrstuvwxyz{|}^~_ --";

static char zenkaku_table[] =
"ɡʡˡܡݡǡ䡩£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣ڡΡϡСáѡ";

static char str_buffer[1024];

/*
------------------------------------------------------------------------------
	FUNCTION:
	<zentohan>: convert (zenkaku)str -> (hankaku)str_out
------------------------------------------------------------------------------
*/

char *zentohan(str) 
    char *str;
{
    char *str_out = str_buffer;

    while (*str) {
        if (iskanji(str[0]) && iskanji(str[1])) {
            int ptr;

            for (ptr = 0; zenkaku_table[ptr]; ptr += 2) {
                if (zenkaku_table[ptr] == str[0] &&
                    zenkaku_table[ptr+1] == str[1]) {
                    *str_out++ = hankaku_table[ptr / 2];
                    break;
                }
            }
            if (zenkaku_table[ptr] == 0) {
                *str_out++ = str[0];
                *str_out++ = str[1];
            }
            str += 2;
        } else {
            *str_out++ = *str++;
        }
    }
    *str_out = 0;
    return str_buffer;
}

/*
------------------------------------------------------------------------------
        FUNCTION
        <hantozen>: convert (hankaku)str -> (zenkaku)str_out
------------------------------------------------------------------------------
*/

#if 0 /* 980710 akira-k */
char *hantozen(str)
    unsigned char *str;
{
    char *str_out = str_buffer;
    unsigned char *s;

    while (*str) {
        char *str_tmp;
        
#ifdef SJIS
        if ((0x80<=*str && *str<=0x9f) || (0xe0<=*str && *str<=0xfc)) {
            *str_out++=*str++;
            *str_out++=*str++;
            continue;
        }
#endif
        if (*str < 0x80 && (str_tmp = strchr(hankaku_table, *str)) != NULL) {
            int ptr = str_tmp-hankaku_table;

            *str_out++ = zenkaku_table[ptr<<1];
            *str_out++ = zenkaku_table[(ptr<<1)+1];
        } else {
            *str_out++ = *str;
        }
        str++;
    }
    *str_out = 0;
    return str_buffer;
}

#ifdef SJIS
#endif

/***********************************************************************
 *  euc->sjis, sjis->euc hankakukana->zenkaku code translation 
 ***********************************************************************/

#if 0
unsigned char *sjis2euc(str)
    unsigned char *str;
{
    int sjis = 0;
    unsigned char *s;
    
    s=str;
    for (; *s; s++) {
        if (*s >= 0x80){
            if (*s >= 0xe0) *s -= 0x40;
            *s = ((*s - 0x30) << 1);
            if (*(s+1) >= 0x9f) *(s+1) += 2;
            else {
                (*s)--;
                if (*(s+1) >= 0x80) *(s+1) += 0x60;
                else *(s+1) += 0x61;
            }
            s++;
        }
    }
    return str;
}
#endif

unsigned char *euc2sjis(str)
    unsigned char *str;
{
    unsigned char *s;
    for(s=str;*s;s++){
        if (*s>=0x80){
            if (*s & 1) {
                *(s+1) -= 0x61;
                if (*(s+1) >= 0x7f) (*(s+1))++;
            } else *(s+1) -= 2;

            *s = ((*s + 1) >> 1) + 0x30;
            if (*s >= 0xa0) *s += 0x40;
            s++;
        }
    }
    return str;
}


static void sjis2euc1(hi, lo)
    unsigned char *hi, *lo;
{
    if (*hi >= 0xe0) (*hi) -= 0x40;
    *hi = ((*hi - 0x30) << 1);
    
    if (*lo >= 0x9f) (*lo) += 2;
    else {
	(*hi)--;
	if (*lo >= 0x80) (*lo) += 0x60;
	else (*lo) += 0x61;
    }
}

/***********************************************************************
 * hankana2zenkana1
 *
 * return code: ȤΥݥ󥿤ɬפ˱ƿʤ᤿ݥ
 ***********************************************************************/
static unsigned char *hankana2zenkana1(moto, ato)
    unsigned char *moto, *ato;
{
    static unsigned char hankaku[] =
      "֡ס򥡥á"
        "ĥƥȥʥ˥̥ͥΥϥҥեإۥޥߥ󡫡";
    unsigned char *p, *s;
    int dakuten;

    p = ato;
    s = moto;
    if (*(s+1) == 0xde && 
	(*s>=0xb6 && *s<=0xc4 || *s>=0xca && *s<=0xce))
      dakuten = 1;
    else if (*(s+1) == 0xdf && *s>=0xca && *s<=0xce)
      dakuten = 2;
    else
      dakuten = 0;
    *p++ = hankaku[(*s - 0xa1) * 2];
    *p++ = hankaku[(*s - 0xa1) * 2 + 1] + dakuten;
    if (dakuten){
	s++;
    }
    return s;
}

unsigned char *sjis2euc(str)
    unsigned char *str;
{
    unsigned char tmp[8192 /*CHA_INPUT_SIZE*/], *p, *s;

    p = tmp;
    for (s = str; *s; s++){
        if ((0x80 <= *s && *s < 0xa0) || (0xe0 <= *s && *s <= 0xfc)) {
            *p++ = *s++;
            *p++ = *s;
	    sjis2euc1(p-2,p-1);
        } else if (0xa1<=*s && *s<=0xdf) {
	    s=hankana2zenkana1(s,p);
	    p+=2;
	    sjis2euc1(p-2,p-1);
        } else {
            *p++ = *s;
        }
    }
    *p = '\0';
    strcpy(str, tmp);
    return str;
}


unsigned char *hankana2zenkana(str)
    unsigned char *str;
{
    unsigned char tmp[8192 /*CHA_INPUT_SIZE*/], *p, *s;

    p = tmp;
    for (s = str; *s; s++){
        if ((0x80 <= *s && *s < 0xa0) || (0xe0 <= *s && *s <= 0xfc)) {
            *p++ = *s++;
            *p++ = *s;
        } else if (0xa1<=*s && *s<=0xdf) {
	    s=hankana2zenkana1(s,p);
	    p+=2;
        } else {
            *p++ = *s;
        }
    }
    *p = '\0';
    strcpy(str, tmp);
    return str;
}
#endif /* SJIS */

#ifdef KOCHA2
static int jaso2ks1(s)
    unsigned char *s;
{
    int i;
    if (*s != 0xa4) return -1;
    for (i = 0; i < 2350; i++) {
	if (!strcmp(s, ksjaso[i])) {
	    i = (int)(i / 94) * 0x100 + (i % 94) + 0xb0a1; 
	    s[0] = i / 0x100;
	    s[1] = i % 0x100;
	    s[2] = '\0';
	    return i;
	}
    }
    return -1;
}

char *is_moeum(s1)
    char *s1;
{
    int i;
    char *s2;
    static char moeum[] = "¤äĤŤƤǤȤɤʤˤ̤ͤΤϤФѤҤ";
    for (s2 = moeum; *s2; s2 += 2) {
	if (s1[0] == s2[0] && s1[1] == s2[1]) return s2;
    }
    return NULL;
}    

/*
 * translation JASO to KS C 5601 97/03/19 04:32:28
 */
jaso2ks(str)
    unsigned char *str;
{
    int fl, i;
    unsigned char outstr[8192], buf[20], *in, *out, *stk, bak[2];
    
    int tbl[][6] = {{1, 0, 0, 0, 0, 0}, {1, 2, 3, 4, 4, 4},
		      {5, 0, 0, 4, 0, 0}, {5, 0, 0, 0, 4, 0},
		      {5, 0, 0, 0, 0, 0}, {1, 2, 3, 4, 4, 4}};
    
    for (in = str, out = outstr, fl = 0, stk = buf; *in && in ;in++) {
	if (*in < 0xa1) {
	    *stk = '\0';
	    jaso2ks1(buf);
	    strcpy(out, buf);
	    out += strlen(buf);
	    stk = buf;
	    *out++ = *in;
	    fl = 0;
	}
	else if (*in == 0xa4 && 0xa1 <= in[1] && in[1] <= 0xd3) { 
	    /* if jaso */
	    if (!is_moeum(in)) {
		switch (fl) {
		  case 1:
		  case 5:
		    *stk = '\0';
		    jaso2ks1(buf);
		    strcpy(out, buf);
		    out += strlen(buf);
		    stk = buf;
		    break;
		}
		fl = tbl[fl][0];
		*stk++ = in[0];
		*stk++ = in[1];
	    } else {
		if ((fl == 2 && in[1] == (unsigned char)""[1])
		    || (fl == 3 && in[1] == (unsigned char)""[1])) {
		    *stk++ = in[0];
		    *stk++ = in[1];
		} else 
		    switch(fl) {
		      case 2:
		      case 3:
		      case 4:
			*stk = '\0';
			strcpy(out, buf);
			out += strlen(buf);
			stk = buf;
			*out++ = in[0];
			*out++ = in[1];
			break;
		      case 5:
			bak[0] = stk[-2];
			bak[1] = stk[-1];
			stk[-2] = '\0';
			jaso2ks1(buf);
			strcpy(out, buf);
			out += strlen(buf);
			stk = buf;
			*stk++ = bak[0];
			*stk++ = bak[1];
		      default:
			*stk++ = in[0];
			*stk++ = in[1];
		    }
		if (in[1] == (unsigned char)""[1]) 
		    fl = tbl[fl][1];
		else if (in[1] == (unsigned char)""[1] 
			 || in[1] == (unsigned char)""[1] 
			 || in[1] == (unsigned char)""[1])
		    fl = tbl[fl][2];
		else if (in[1] == (unsigned char)""[1])
		    fl = tbl[fl][3];
		else if (in[1] == (unsigned char)""[1])
		    fl = tbl[fl][4];
		else 
		    fl = tbl[fl][5];
	    }
	    in++;
	} else {
	    *stk = '\0';
	    jaso2ks1(buf);
	    strcpy(out, buf);
	    out += strlen(buf);
	    stk = buf;
	    if (in[0] == 0xa1 && in[1] == 0xa1) {
		*out++ = ' ';
		in++;
	    } else {
		*out++ = *in++;
		*out++ = *in;
	    }
	    fl = 0;
	}
    }
    if (stk != buf) { 
	*stk = '\0';
	jaso2ks1(buf);
	strcpy(out, buf);
    } else {
	    *out = '\0';
	}
    fl = 0;
    strcpy(str, outstr);
}

/*
 * translation KS C 5601 to JASO 97/03/2 06:52:29
 */
unsigned char *ks2jaso(input, output)
    unsigned char *input;
    unsigned char *output;
{
    unsigned char *in, *out, *p;
    unsigned int i;
    static unsigned char sp[3] = "";
    
    for (in = input, out = output; in && *in; in++) {
	if (*in >= 0xa1){
	    i = (in[0] - 0xb0) * 94 + (in[1] - 0xa1);
	    if (0 <= i && i < 2350){
		for (p = ksjaso[i]; p && *p; p++, out++)
		  *out = *p;
	    }else{
		*out++ = in[0];
		*out++ = in[1];
	    }
	    in++;
	}else{
	    if (*in == ' ') {
		*out++ = sp[0];
		*out++ = sp[1];
	    }
	    else *out++ = *in;
	}
    }
    *out = '\0';
    return output;
}
#endif /* KOCHA2 */

