/*--------------------------------------------------------------*
 *                                                              *
 *         SUFARY --- Suffix Array ΤΥ饤֥       *
 *                                                              *
 *  sufary.h - SUFARY饤֥إåե                   *
 *                                                              *
 *--------------------------------------------------------------*/

#ifndef _SUFARY_H_
#define _SUFARY_H_

#include <sys/types.h>
#include <sys/stat.h>
#ifndef NO_MMAP
#include <sys/mman.h>
#endif

#ifdef _WIN32
typedef unsigned char * caddr_t;
#endif /* _WIN32 */

#ifndef KEYWORD_MAX_LENGTH
#define KEYWORD_MAX_LENGTH 5000
#endif

/* ޥɤ */
typedef enum eresult_{
  CONT,
  FAIL,
  EXIT,
  ERROR
} eresult;

/* 顼 */
typedef enum eerror_ {
  NOERROR,
  COMMAND,
  MEMORY,
  FILEIN,
  FILEOUT,
  STRUCTURE,
  UNKNOWN
} eerror;

/* SUFARY¤ */
typedef struct {
  eerror ee;      /* Х륨顼ɤݻ */
  long arraysize; /* Array 礭 */
  long left;  /* ϰϤκü(ϰϤ¦ؤ)   g_bottom */
  long right;     /* ϰϤαü(ϰϤ¦ؤ)   g_top */
  /*char keyword[KEYWORD_MAX_LENGTH];*/  /*  */
  int txtfd;      /* ƥȥե */
  int aryfd;      /* 쥤ե */
  off_t txtsz;    /* ƥȥեΥ */
  off_t arysz;    /* 쥤եΥ */
  caddr_t txtmap; /* ƥȥեΥޥåץɥ쥹 */
  caddr_t arymap; /* 쥤եΥޥåץɥ쥹 */
  caddr_t aryorig; /* ꥸʥΥ쥤 */
  caddr_t op_result; /* 黻 */
  char filename[256]; /* ե̾(text file) for DEBUG */
  /*ary_sort_t sort; *//* arymapΥȾ */
} SUFARY;

/******************************************************************************
 *   long sa_left(SUFARY *ary);
 *   long sa_right(SUFARY *ary);
 *
 * purpose
 *   줾졢SUFARYѿaryθߤ left, right ֤ͤ
 *
 * parameters
 *   ary : оarray
 *
 * return value
 *   ary->left (sa_left), ary->right (sa_right)
 *
 * description
 *   SUFARY¤桼ľܸʤɬ
 *****************************************************************************/
#define sa_left(ary)   (ary->left)
#define sa_right(ary)  (ary->right)

/* ץȥ ѥ롼 */
/*** select.c ***/
/* level 1 : ܴؿ */
eresult sa_sel();
char *sa_getblock();
char *sa_getline();
char *sa_getlines();
char *sa_aryidx2txtptr();
void sa_reset();
/* level 2 :  */
eresult sa_search();
long sa_aryidx2txtidx();
char *sa_txtidx2txtptr();
long *sa_common_prefix_search();
void sa_mojibakebousi();
void sa_ctrl_code_tubusi();
/* level 3 : ԺѤβǽ */
eresult sa_uniq_near();

/* 켰ؿ : Ver.2.0 ǤϺͽ */
/*long sa_bottom(SUFARY *ary); *//* = sa_left */
/*long sa_top(SUFARY *ary); *//* = sa_right */
/*char *sa_getkatamari(SUFARY *ary,long pos,char* d1,char* d2);/* =sa_getblock */
/*long sa_arraytotext(SUFARY *ary, long pos); *//* = sa_aryidx2txtidx  */
/*char *sa_gettext(SUFARY *ary, long pos); *//* = sa_aryidx2txtptr */
/*long *sa_morph_search(SUFARY *ary, char *kw, char *we); *//* =sa_c._p._search */


/*** chfile.c ***/
/* level 1 : ܴؿ  */
SUFARY *sa_openfiles();
void sa_closefiles();
/* level 2 : ܴؿƤӽФƤؿñΤǻȤȤϤʤ */
eresult sa_opentextfile();
eresult sa_openarrayfile();
void sa_closetextfile();
void sa_closearrayfile();

#endif /* _SUFARY_H_ */
