#include "chadic.h"

#ifdef _WIN32
#define	strcasecmp	stricmp
#define	strncasecmp	strnicmp
#endif /* _WIN32 */

#define PATH_NUM            1024
#define INFO_MAX            129 /* ̣ʸȤƳǼ륹åȤΥ */
#define CHA_INPUT_SIZE      8192
#define UNDEF_HINSI_MAX     256

/* for debug */
#if 0
#define debug_print(s) {printf("[%s:%d:%s]\n",__FILE__,__LINE__,s);fflush(stdout);}
#else
#define debug_print(s)
#endif


/*
 * structures
 */

typedef struct _mrph2_t {
    char	*midasi;
    char	*yomi;
    char        *info; /* ̣ʸȤƳǼ륹å */
#ifdef VGRAM
    char	*base;
    char	*pron;
    char	*comp;
#endif
    short	base_length;

#ifdef VGRAM
    unsigned short hinsi;
#else
    unsigned char hinsi;
    unsigned char bunrui;
#endif
    unsigned char ktype;
    unsigned char kform;
    char	is_undef;

    unsigned short weight;
    short	length;
    short	con_tbl;
} mrph2_t;

typedef struct _path_t {
    int   mrph_p;
    short state;
    short start;
    short end;
    int   cost;
    int   *path;     /* Υѥξ */
    int   do_print;
} path_t;

typedef struct _anno_info {
    int hinsi;
#ifndef VGRAM
    int bunrui;
#endif
    char *str1, *str2;
    int len1, len2;
} anno_info;

typedef struct _undef_info {
    int cost, cost_step;
    int con_tbl;
    int hinsi;
#ifndef VGRAM
    int bunrui;
#endif
} undef_info;

/*
 * global variables
 */

extern mrph2_t *Mrph;
extern path_t *Path;
extern int Path_num;
extern int Con_cost_weight, Con_cost_undef, Mrph_cost_weight, Cost_width;
extern int Space_pos_hinsi;
#ifndef VGRAM
extern int Space_pos_bunrui;
#endif
extern anno_info Anno_info[UNDEF_HINSI_MAX];
extern undef_info Undef_info[UNDEF_HINSI_MAX];
extern int Undef_info_num;
extern int Lang_j, Lang_e;
extern char *Bos_string;
extern char *Eos_string;
extern int Output_compo;

/*
 * functions
 */

/* init.c */
extern void read_chasenrc_fp();
extern void chasen_init();

/* print.c */
extern char *get_cha_output();
extern void set_cha_fput();
extern void set_cha_output();
extern void printf_mrph();
extern void cha_print_path();
extern void cha_print_bos_eos();
extern void cha_print_hinsi_table();
extern void cha_print_ctype_table();
extern void cha_print_cform_table();

/* parse.c */
extern void get_mrph_data();
extern int chasen_sent();

/* chalib.c */
extern void cha_version();
extern void set_opt_form();
extern void set_cost_width();
extern int chasen_getopt_argv();
extern int chasen_fparse();
extern int chasen_sparse();
extern char *chasen_fparse_tostr();
extern char *chasen_sparse_tostr();
extern char *cha_fgets();
extern void read_patdic();

/* jfgets.c */
extern void set_jfgets_delimiter();
extern char *fget_line();
extern char *jfgets();
extern int cha_jistoeuc();

