%{
static char *rcsID = 
  "$Header: /home/tomoak-i/proj-cha/mkjmdic/transdic.y,v 1.1 1996/11/04 00:40:12 tomoak-i Exp $";

#include <assert.h>
#include "chadic.h"
#ifndef DEBUG
#define NDEBUG
#endif

#define	NUM_MIDASI	32
#define COMMENTCHAR	';'
#define BPARENTHESIS	'('
#define BPARENTHESIS2	'<'
#define BPARENTHESIS3	'['
#define EPARENTHESIS	')'
#define EPARENTHESIS2	'>'
#define EPARENTHESIS3	']'
#define SCANATOM	"%[^(;) \n\t]"
#define NILSYMBOL	"NIL"
#define HINSI_UNDEF	0

/* ǼηǽŤߤǥ(-log(p))ȤưѤ */
#define MRPH_DEFAULT_COST 1

typedef struct {
  char   s[MIDASI_MAX];
  double w;
} midasi_t;

static midasi_t	midasi[NUM_MIDASI];
static int	num;
static char	yomi[BUFSIZ];
static char	katuyou[BUFSIZ];
static char	imi[BUFSIZ];
static char	con[BUFSIZ];
static mrph_t	mrph;
static int	isProp;
static FILE	*readfp, *fp_w;
static int	default_hinsi_id = HINSI_UNDEF;
static int	default_bunrui_id;
static char	*hinsi_queue[256];
static char	**queueptr;
static int	queuelev;
static int	queuemax;

static int put_dic();
static void trim_yomi_gobi();
static int trim_midasi_gobi();
static void print_mrph();
static void print_mrph_loop();
static int yyerror();
static int yywrap();
static int yylex();
static int yylex_adj();
static void mainprcs();
static int push_queue();
static int clear_queue();
static int set_default_hinsi();
int main();
%}

%union {
  char str[128];
}

%token	STRINGTOKEN MIDASI_SYM YOMI_SYM KATUYOU_SYM IMI_SYM CON_SYM
%token  DEFHINSI_SYM
%start	dictionary
%type <str> STRINGTOKEN
%%

dictionary	: dictionary '(' switch_propmode rootdef switch_propmode ')'
		    {/* */}
		| /* empty */
		    {/* Do nothing */}
		;

rootdef		: some_infos
		    {put_dic();}
		| def_or_full
		    {/* */}
		;

def_or_full	: DEFHINSI_SYM '(' switch_strmode def_hinsi_list ')'
		    {set_default_hinsi();}
		| STRINGTOKEN
		    {push_queue($1);}
		full_entry_loop
                    {/* */}
		;

def_hinsi_list	: STRINGTOKEN
		    {push_queue($1);}
		| def_hinsi_list STRINGTOKEN
		    {push_queue($2);}
		;

full_entry_loop	: mrph_info_list
		    {put_dic();}
		| '(' STRINGTOKEN
		    {push_queue($2);}
		full_entry_loop ')'
		    {/* */}
		;

mrph_info_list	: '(' some_infos ')'   
		    {/* Do nothing */}
		| mrph_info_list '(' some_infos ')'
		    {/* Do nothing */}
		;

some_infos	: some_infos '(' switch_propmode some_info ')'
		    {/* Do nothing */}
		| '(' switch_propmode some_info ')'
		    {/* Do nothing */}
		;

some_info	: MIDASI_SYM  switch_strmode midasi_list
		    {/* Do nothing */}
		| YOMI_SYM    switch_strmode STRINGTOKEN
		    {strcpy(yomi, $3);}
		| KATUYOU_SYM switch_strmode STRINGTOKEN
		    {strcpy(katuyou, $3);}
		| IMI_SYM     switch_strmode STRINGTOKEN
		    {strcpy(imi, $3);}
		| CON_SYM     switch_strmode STRINGTOKEN
		    {strcpy(con, $3);}
		;

switch_propmode	: /* empty */
		    {isProp = 1;}
		;

switch_strmode	: /* empty */
		    {isProp = 0;}
		;
midasi_list	: midasi_list midasi_elem
		    {/* */}
		| midasi_elem
		    {/* */}
		;

midasi_elem	: STRINGTOKEN 
		    {strcpy(midasi[num].s, hantozen($1));
		   midasi[num++].w = MRPH_DEFAULT_WEIGHT * MRPH_DEFAULT_COST;}
		| '(' STRINGTOKEN ')'
		    {strcpy(midasi[num].s, hantozen($2));
		   midasi[num++].w = MRPH_DEFAULT_WEIGHT * MRPH_DEFAULT_COST;}
		| '(' STRINGTOKEN STRINGTOKEN ')'
		    {strcpy(midasi[num].s, hantozen($2));
		   midasi[num++].w = atof($3) * MRPH_DEFAULT_WEIGHT;}

%%
#if 0
static caddr_t start, limit;
#endif

static int put_dic()
{
  /* mrph_t m;*/
  int i;
  unsigned hval;
  unsigned char *p, *q;
  int haskatuyou;
  
  if (!num)
    return 0;
  
#ifdef VGRAM
  if (queuelev > 0 && hinsi_queue[0][0]){
    mrph.hinsi = get_nhinsi_str_id(hinsi_queue);
    clear_queue();
  } else
    mrph.hinsi = default_hinsi_id;
  
  if (mrph.hinsi == HINSI_UNDEF) goto ESCAPE; /* 970301 tatuo: ERRæ*/
#else
  if (queuelev > 0 && hinsi_queue[0][0]){
    mrph.hinsi = get_hinsi_id(hinsi_queue[0]);
    if (queuelev > 1 && hinsi_queue[1][0])
      mrph.bunrui = get_bunrui_id(hinsi_queue[1], mrph.hinsi);
    else
      mrph.bunrui = 0;
    clear_queue();
  } else {
    mrph.hinsi = default_hinsi_id;
    mrph.bunrui = default_bunrui_id;
  }
  if (mrph.hinsi == HINSI_UNDEF) goto ESCAPE; /* 970301 tatuo: ERRæ*/
/*
  mrph.hinsi = get_hinsi_id(hinsi);
  if (bunrui[0])
    mrph.bunrui = get_bunrui_id(bunrui, mrph.hinsi);
  else
    mrph.bunrui = 0;
*/
#endif
  strcpy(mrph.yomi, yomi);
  
#ifdef VGRAM
  haskatuyou = Hinsi[mrph.hinsi].kt;
#else
  haskatuyou = Class[mrph.hinsi][mrph.bunrui].kt;
#endif
  
  if (haskatuyou){
    mrph.ktype = get_type_id(katuyou);
    if(mrph.ktype == 255) { /* 970301 tatuo: ERRæ  errid = 255 */
      fprintf(stderr,"  -> [%s]",mrph.yomi);
      goto ESCAPE;
    }
    trim_yomi_gobi(&mrph);
  } else
    mrph.ktype = 0;
  
  for (i = 0; i < num; i++){
    strcpy(mrph.midasi, midasi[i].s);
    mrph.weight = (midasi[i].w > 255)? 255: midasi[i].w;
    
    if (con[0]){
      check_edrtable_str(&mrph, con);
    } else {
      if(check_table(&mrph) == 0) goto ESCAPE; /* 970301 tatuo: ERRæ */
    }
    
    if (haskatuyou){
      int tatuo_tmp; /* 970301 tatuo: Ф쥨顼æ  errod = 100 */
      tatuo_tmp = trim_midasi_gobi(&mrph); 
      if(tatuo_tmp == 100) goto ESCAPE;
      if (tatuo_tmp)
	print_mrph(mrph);
      else
	print_mrph_loop(mrph);
    } else 
      print_mrph(mrph);
  }
 ESCAPE: /* 970301 tatuo: 顼λƨ */
  num = 0;
/*  bunrui[0] = 0;*/
  katuyou[0] = 0;
  imi[0] = 0;
  con[0] = 0;
  return 0;
}

static void trim_yomi_gobi(mrph_p)
     mrph_t *mrph_p;
{
  char *str = "ܷ";
  int  i;
  
  for (i = 1; strcmp(Form[mrph_p->ktype][i].name, str); i++);
  
  mrph_p->yomi[strlen(mrph_p->yomi) - 
	       strlen(Form[mrph_p->ktype][i].gobi)]='\0';
}

static int strcmp_tail(s1, s2)
    char *s1, *s2;
{
    int diff_len;

    diff_len = strlen(s1) - strlen(s2);

    if (diff_len >= 0)
      return strcmp(s1 + diff_len, s2);
    else
      return strcmp(s2 - diff_len, s1);
}

static int trim_midasi_gobi(mrph_p)
     mrph_t *mrph_p;
{
  char *str = "ܷ";
  int	i;
  int l, k;
  
  for (i = 1; strcmp(Form[mrph_p->ktype][i].name, str); i++);

  if (!strcmp_tail(mrph_p->midasi, Form[mrph_p->ktype][i].gobi)){
    l = strlen(mrph_p->midasi);
    k = strlen(Form[mrph_p->ktype][i].gobi);
    mrph_p->midasi[l-k]='\0';
    return l-k;
  }
  
  else {
    cha_exit_file(-1,"Can't trim gobi : %s", mrph_p->midasi);
    return 100; /* 970301 tatuo: 顼λ 100 ()֤*/
  }
/*
  exit(1);
  */
  /*    else
	error_in_trans(ConflictGobi, mrph_p->midasi);*/
}

static void print_mrph(mrph)
     mrph_t mrph;
{
#ifdef SJIS
  unsigned char midasi_str[100], yomi_str[100];
  
  strcpy(midasi_str, mrph.midasi);
  strcpy(yomi_str, mrph.yomi);
  sjis2euc(midasi_str);
  sjis2euc(yomi_str);
  
#else
  char *midasi_str = mrph.midasi;
  char *yomi_str = mrph.yomi;
#endif
  
#ifdef VGRAM
  fprintf(fp_w, "%s\t%d %d %d %d %s %d ",
	  midasi_str, mrph.hinsi,
	  mrph.ktype, mrph.kform, mrph.weight,
	  yomi_str, mrph.con_tbl);
#else
  fprintf(fp_w, "%s\t%d %d %d %d %d %s %d ",
	  midasi_str, mrph.hinsi, mrph.bunrui,
	  mrph.ktype, mrph.kform, mrph.weight,
	  yomi_str, mrph.con_tbl);
#endif
  
  if (!imi[0]) {
    fputs(NILSYMBOL, fp_w);
    fputc('\n', fp_w);
    return;
  }
#ifdef SJIS
  fputs((char *)sjis2euc((unsigned char *)imi), fp_w);
#else
  fputs(imi, fp_w);
#endif
  fputc('\n', fp_w);
  
  return;
}

static void print_mrph_loop(mrph)
     mrph_t mrph;
{
  int i;
  
  for ( i=1; Form[mrph.ktype][i].name; i++ ) {
    if ( strlen(Form[mrph.ktype][i].gobi) ) {
#ifdef SJIS
      unsigned char gobi_str[100];
      strcpy(gobi_str, Form[mrph.ktype][i].gobi);
      sjis2euc(gobi_str);
#else
      unsigned char *gobi_str = (unsigned char *)Form[mrph.ktype][i].gobi;
#endif
#ifdef VGRAM
      fprintf(fp_w, "%s\t%d %d %d %d %s %d ",
              gobi_str, mrph.hinsi,
              mrph.ktype, i, mrph.weight,
              gobi_str, mrph.con_tbl + i - 1);
#else
      fprintf(fp_w, "%s\t%d %d %d %d %d %s %d ",
              gobi_str, mrph.hinsi,
              mrph.bunrui, mrph.ktype, i, mrph.weight,
              gobi_str, mrph.con_tbl + i - 1);
#endif
      
      if (!imi[0]){
	fputs(NILSYMBOL, fp_w);
	fputc('\n', fp_w);
      } else {
#ifdef SJIS
	fputs((char *)sjis2euc((unsigned char *)imi), fp_w);
#else
	fputs(imi, fp_w);
#endif
	fputc('\n', fp_w);
      }
    }
  }
}

static unsigned char *propstr =
(unsigned char *)"Фɤ߳ѷ̣Ϣ°ʻ";
/*                0       8   12    18      26      34 */

static int yywrap()
{
  return 1;
}

static int yylex()
{
  unsigned char *ptr;
  int ret = yylex_adj();
  if (!isProp || ret == BPARENTHESIS || ret == EPARENTHESIS || ret == 0){
    return ret;
  }
  
  ptr = (unsigned char *)strstr(propstr, yylval.str);
  if (!ptr){
    return ret;
  }
  switch(ptr - propstr){
  case 0:
    return MIDASI_SYM;
  case 8:
    return YOMI_SYM;
  case 12:
    return KATUYOU_SYM;
  case 18:
    return IMI_SYM;
  case 26:
    return CON_SYM;
  case 34:
    return DEFHINSI_SYM;
  default:
    return STRINGTOKEN;
  }
}

static int yyerror(p)
     char *p;
{
  cha_exit_file(1, p);
}

static int yylex_adj()
{
  int ch;
  unsigned char *tok;
  unsigned char uch;
  int i;
  
  while ((ch = getc(readfp)) != EOF){
    switch (ch){
    case '\n': /* Ԥ򥹥å(Կ򥫥) */
      LineNoForError = LineNo++;
    case ' ':  /* 򥹥å */
    case '\t': /* ֤⥹å */
      break;
    case COMMENTCHAR: /* ; ˤ륳Ȥγ(ޤǥå) */
      while(ch != '\n'){
	ch = getc(readfp);
      }
      LineNoForError = LineNo++;
      break;
    case BPARENTHESIS: /* ( */
    case EPARENTHESIS: /* ) */
      yylval.str[0] = ch;
      yylval.str[1] = 0;
#ifndef NDEBUG
      puts(yylval.str);
#endif
      return ch;
    default: /* ʸ ⤷ "ʸ"ס'ʸ' */
      tok = (unsigned char *)yylval.str;
      
      /* "ʸ"or'ʸ' ν\פˤ륨פ⤢ꡣ*/
      if (ch == '\"' || ch == '\'') {
	i = 0;
	uch = ch;
	/* ľ \ Ǥʤ "ס' õ */
#ifdef _WIN32
	for (i = 0, ch = getc(readfp);
	     (ch != uch || (tok[-1] == '\\' && tok[-2] < 0x80)) && ch != EOF;
	     i++, ch = getc(readfp)) {
	  if ((0x80<=(unsigned char)ch && (unsigned char)ch<=0x9f) 
	      || (0xe0<=(unsigned char)ch && (unsigned char)ch<=0xfc)) {
	    *tok++ = ch;
	    *tok++ = getc(readfp);
	    continue;
	  }
	  if (tok[-1] == '\\')
	    tok--;
	  *tok++ = ch;
	}
#else
	for (i = 0, ch = getc(readfp);
	     (ch != uch || tok[-1] == '\\') && ch != EOF;
	     i++, ch = getc(readfp)) {
	  if (tok[-1] == '\\')
	    tok--;
	  *tok++ = ch;
	}
#endif
	*tok = 0;
#ifndef NDEBUG
	printf("'STRING'(%d):[%s]\n", i, yylval.str);
#endif
	return STRINGTOKEN;
      }
      
      /* ̾Ρʸפν */
      *tok++ = ch;
#ifdef SJIS
      if ((0x80<=ch && ch<=0x9f) || (0xe0<=ch && ch<=0xfc)){
	*tok++=getc(readfp);
      }
#endif
      /* ζor̤õ\פˤ륨פ⤢ꡣ */
      for (i = 0, ch = getc(readfp);
	   (ch != EPARENTHESIS && ch != ' ' && ch != '\t' && ch != '\n' ||
	    (tok[-1] == '\\' && tok[-2] < 0x80)) && ch != EOF;
	   i++, ch = getc(readfp)) {
#ifdef SJIS
	if ((0x80<=ch && ch<=0x9f) || (0xe0<=ch && ch<=0xfc)){
	  *tok++=ch;
	  *tok++=getc(readfp);
	  continue;
	}
#endif
	if (tok[-1] == '\\')
	  tok--;
	*tok++ = ch;
	if (ch == '\n')
	  LineNoForError = LineNo++;
      }
      *tok = 0;
      ungetc(ch, readfp);
#ifndef NDEBUG
      printf("STRING(%d):[%s]\n", i, yylval.str);
#endif
      return STRINGTOKEN;
    }
  }
  
  yylval.str[0] = 0;
#ifndef NDEBUG
  puts("No more token");
#endif
  return 0;  
}

static void translate(dicfile, fp_out)
     char *dicfile;
     FILE *fp_out;
{
  readfp = cha_fopen(dicfile, "r", 1);
  if (fp_out)
    fprintf(fp_out, "%s\n", dicfile);
  LineNoForError = LineNo = 1;
  yyparse();
  fclose(readfp);
  clear_queue();

  default_hinsi_id = HINSI_UNDEF;
}

/*
------------------------------------------------------------------------------
   PROCEDURE:
   <mainprcs>: main process (call <translate>)
------------------------------------------------------------------------------
*/

static void mainprcs(argv, fp_out)
     char *argv[];
     FILE *fp_out;
{
  time_t t0, t1;
  int  dt;
  char *tmp;
#ifdef _WIN32
  struct _finddata_t file;
  long hFile;
#endif
  
  time(&t0);

  if (fp_out)
    fprintf(fp_out, "parsing dictionaries...\n");

  queueptr = hinsi_queue;

  for (; *argv != NULL && **argv != '-'; argv++) {
#ifdef _WIN32
    hFile = _findfirst(*argv, &file);
    do {
      translate(file.name, fp_out);
    } while (!_findnext(hFile, &file));
    _findclose( hFile );
#else
    translate(*argv, fp_out);
#endif
  }
  
  time(&t1);
  
  dt = t1 - t0;
  if (fp_out)
    fprintf(fp_out, "processing time: %d sec\n", dt);
}
/*
------------------------------------------------------------------------------
   PROCEDURE:
   <usage>: print usage on "stderr", and "exit"
------------------------------------------------------------------------------
   */

static void usage()
{
  fprintf(stderr, "usage: transdic [ -q ] [ -o outfile ] dicfile...\n");
  exit(1);
}

static int push_queue(elem)
     char *elem;
{
  int i;

  /* allocate area for new element if no space */
  if (++queuelev > queuemax){
    *queueptr = (char *)cha_malloc(BUFSIZ);
    queuemax++;
  }

  /* copy element to current queue's top */
  strcpy(*queueptr++, elem);

  /* returns zero */
  return 0;
}

static int clear_queue()
{
  int i;

  /* clear all allocated queue... */
  queuelev = 0;
  for (i = 0, queueptr = hinsi_queue; i < queuemax; i++, queueptr++)
    *queueptr[0] = 0;
  
  /* restore queue pointer */
  queueptr = hinsi_queue;
  
  /* returns zero */
  return 0;
}

static int set_default_hinsi()
{
#ifdef VGRAM
  default_hinsi_id = get_nhinsi_str_id(hinsi_queue);
#else
  default_hinsi_id = get_hinsi_id(hinsi_queue[0]);
  if (queuelev > 1 && hinsi_queue[1])
    default_bunrui_id = get_bunrui_id(hinsi_queue[1], default_hinsi_id);
  else
    default_bunrui_id = 0;
#endif
  clear_queue();

  return 0;
}

/*
------------------------------------------------------------------------------
   FUNCTION
   <main>: main routine
------------------------------------------------------------------------------
   */
int main(argc, argv)
     int argc;
     char *argv[];
{
  FILE *fp_out;
  int c;

  set_progpath(argv[0]);

  fp_out = stderr;
  fp_w = stdout;

  while ((c = cha_getopt(argv, "qo:", stderr)) != EOF) {
      switch (c) {
	case 'q':
	  fp_out = NULL;
	  break;
	case 'o':
	  fp_w = cha_fopen(*argv, "w", 1);
	  break;
	case '?':
	  usage();
      }
  }
  argv += Cha_optind;

  if (argv[0] == NULL)
      usage();

  read_grammar(fp_out, 1, 2);
  read_katuyou(fp_out, 2);
  read_table(fp_out, 2);
  mainprcs(argv, fp_out);

  return 0;
}
