/*--------------------------------------------------------------*
 *                                                              *
 *         SUFARY --- Suffix Array ΤΥ饤֥       *
 *                                                              *
 *  chfile.c - եγĽ                               *
 *                                                              *
 *--------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "chadic.h"
#include "sufary.h"

/* %%%%% ؿƱΤδط %%%%%
   sa_openfiles() 
   +- sa_opentextfile()
   +- sa_openarrayfile()
   sa_cloasefiles() 
   +- sa_closetextfile()
   +- sa_closearrayfile()
   %%%%%%%%%%%%%%%%%%%%%%%% */

static void sa_opentextfile(SUFARY*, char*);
static void sa_openarrayfile(SUFARY*, char*);
static void sa_closetextfile(SUFARY*);
static void sa_closearrayfile(SUFARY*);


/**********************************************
 *        SUFARY *sa_openfiles(char *s, char *t);
 *
 * purpose
 *   ꤵ줿ƥȥե(s)arrayե(t)򳫤
 *   arrayե̾NULL˻ꤹСƥȥե̾
 *   '.ary' ղäΤarrayե̾ˤʤ롣
 *
 * parameters
 *   t : arrayե̾
 *   s : ƥȥե̾
 *
 * return value
 *   줿SUFARYѿ
 **********************************************/
SUFARY *sa_openfiles(s, t)
    char *s, *t;
{
    SUFARY *newary;
    char aryname[8192];

    newary = cha_malloc(sizeof(SUFARY));

    sa_opentextfile(newary, s);
    if (t == NULL){ 
        /*  1 : array file ꤵƤʤ */
	sprintf(aryname, "%s.ary", s); /* (Rel1.4: .pat -> .ary) */
	t = aryname;
    }
    sa_openarrayfile(newary, t);

    return newary;
}


/**********************************************
 *        void sa_opentextfile(SUFARY *ary,char *s);
 *
 * purpose
 *   ƥȥե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s   : ƥȥե̾
 * 
 **********************************************/
static void sa_opentextfile(ary, filename)
    SUFARY *ary;
    char *filename;
{
    off_t size;  /* ե륵 */
    void *map;
  
    /* ˥ץ󤵤ƤΤХ */
    if (ary->txtmap != NULL){
	sa_closetextfile(ary);
    }

    /* եΥץ */
    size = cha_mmap_file(filename, &map);

    ary->txtsz  = size;
    ary->txtmap = map;
}

/**********************************************
 *       void sa_openarrayfile(SUFARY *ary, char *s);
 *
 * purpose
 *   Array ե򳫤
 *
 * parameters
 *   ary : ե(ʤ)ǼSUFARYѿ
 *   s : Array ե̾
 *
 **********************************************/
static void sa_openarrayfile(ary, filename)
    SUFARY *ary;
    char *filename;
{
    off_t size;  /* ե륵 */
    void *map;

    /* ˥ץ󤵤ƤΤХ */
    if (ary->arymap != NULL){
	sa_closearrayfile(ary);
    }

    size = cha_mmap_file(filename, &map);
    ary->arysz = size;
    ary->arraysize = size / sizeof(long);
    ary->arymap = map;
    /* left, right ϸϰϤ¦ؤ  980319 */
    ary->left = 0;
    ary->right = ary->arraysize - 1;
}

/**********************************************
 *       void sa_closefiles(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿եĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 *
 * description
 *   ƥȥեarrayեƱĤ
 **********************************************/
void sa_closefiles(ary)
    SUFARY *ary;
{
    sa_closetextfile(ary);
    sa_closearrayfile(ary);
    cha_free(ary);
}

/**********************************************
 *        void sa_closetextfile(SUFARY *ary);
 *
 * purpose
 *   ꤵ줿ƥȥեĤ
 * 
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
static void sa_closetextfile(ary)
    SUFARY *ary;
{
    if (ary->txtmap != NULL){
	/* mmap β */
	cha_munmap_file(ary->txtmap, ary->txtsz);
	ary->txtmap = NULL;
	ary->txtsz = 0;
    }
}

/**********************************************
 *        void sa_closearrayfile(void);
 *
 * purpose
 *   ꤵ줿arrayեĤ륯
 *
 * parameters
 *   ary : Ĥե˴ؤSUFARYѿ
 *
 * return value
 *   ʤ
 **********************************************/
static void sa_closearrayfile(ary)
    SUFARY *ary;
{
    /* ⡧mmap Ĥɬפ뤫 */
    if (ary->arymap != NULL){
	/* mmap β */
	cha_munmap_file(ary->arymap, ary->arysz);
	ary->arymap = NULL;
	ary->arysz = 0;
    }
    ary->arraysize = 0;
    ary->left = 0;
    ary->right = 0;
}
