#include "config.h"
#include <stdio.h>
#ifndef _WIN32
#include <unistd.h>
#endif
#include <fcntl.h>
#include <stdlib.h>

#if ! defined _WIN32 && ! defined __CYGWIN__
#define O_BINARY 0
#endif

#include "chadic.h"
#include "pat.h"

#define PAT_BUFSIZ 1024

pat_node *pat_malloc_node(void);
static void pat_init_tree_top(pat_node*);
static void pat_com_l(char*, pat_node*);
static void pat_com_s(char*, pat_node*);

/*
 * pat_open
 */
pat_t *pat_open(char *textfile, char *patfile)
{
    pat_t *pat;
    void *map;

    pat = cha_malloc(sizeof(pat_t));
    pat->size = cha_mmap_file(textfile, &map);
    pat->map = map;
    pat->root = pat_malloc_node();
    pat_init_tree_top(pat->root);

    if (patfile != NULL)
	pat_load(pat, patfile);

    return pat;
}

void pat_load(pat_t *pat, char *patfile)
{
    pat_com_l(patfile, pat->root);
}

void pat_save(pat_t *pat, char *patfile)
{
    pat_com_s(patfile, pat->root);
}

void pat_text_reopen(pat_t *pat, char *textfile)
{
    void *map;

    cha_munmap_file(pat->map, pat->size);
    pat = cha_malloc(sizeof(pat_t));
    pat->size = cha_mmap_file(textfile, &map);
    pat->map = map;    
}

/*
 * subroutines for pat_load_anode()
 */
pat_index_list *pat_malloc_index_list(void)
{
    static int idx = 1024;
    static pat_index_list *ptr;

    if (idx == 1024) {
	ptr = cha_malloc(sizeof(pat_index_list) * idx);
	idx = 0;
    }

    return ptr + idx++;
}

pat_node *pat_malloc_node(void)
{
    static int idx = 1024;
    static pat_node *ptr;

    if (idx == 1024) {
	ptr = cha_malloc(sizeof(pat_node) * idx);
	idx = 0;
    }

    return ptr + idx++;
}

static void eputc(int c, int file_discripter)
{
    static int ctr = 0;
    static unsigned char buf[PAT_BUFSIZ];

    buf[ctr] = c;
    ctr++;

    if (ctr == PAT_BUFSIZ) {
	ctr = 0;
	write(file_discripter, buf, PAT_BUFSIZ);
    }

    return;
}

static void dummy(int fd)
{
    eputc(0xff,fd);
    eputc(0xff,fd);
    eputc(0xff,fd);
    eputc(0xff,fd);
}

static unsigned char egetc(int fd)
{
    static int fd_check = -1;
    static char buf[PAT_BUFSIZ];
    static int ctr = sizeof(buf) - 1;

    if (fd != fd_check) { /* Хåեν */
	fd_check = fd;
	ctr = sizeof(buf) - 1;
    }

    if (++ctr == sizeof(buf)){
	ctr = 0;
	read(fd, buf, sizeof(buf));
    }

    return(buf[ctr]);
}

/****************************************************
* pat_load_anode --- ѥȥꥷڤ
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼
*   in --- ե
*   p_ptr --- ΥΡɤǤä˥ǥåǼ
*             ǤäȤϡΥݥ󥿤ϱλҤϤ롣
*
* 르ꥺ
*   åӥåȤɤ߹顢鿷Ρɤ
*     ʬڡʬڤν˺Ƶ
*     ƵλϿäΥݥ󥿤
*     Ƶλ p_ptr 򥤥ǥåγǼȤϤ
*   ǥåɤ߹顢ϳ顢p_ptr->index ˳Ǽ
*
* 
*   ǥåγǼ꤬Ȱ㤦äʤ
*************************************************************************/
static pat_node *pat_load_anode(pat_node *p_ptr, int fd)
{
    unsigned char c;
    pat_node *new_ptr; /* äΡ(==ΥΡ)ؤݥ */
    long tmp_idx;
    pat_index_list *new_l_ptr,*t_ptr=NULL;

#if 0
    static int dbg;
    if (!(++dbg%1000))printf("%d,",dbg);
#endif

    if ((c = egetc(fd)) & 0x80) { /* դäѤνǥåɤ߹ */
	while (c & 0x80) {
	    tmp_idx = (c & 0x3f) << 24;
	    tmp_idx |= egetc(fd) << 16;
	    tmp_idx |= egetc(fd) << 8;
	    tmp_idx |= egetc(fd);

	    if ((p_ptr->il).index < 0)
		new_l_ptr = &(p_ptr->il);
	    else {
		new_l_ptr = pat_malloc_index_list();
		t_ptr->next = new_l_ptr;
	    }
	    new_l_ptr->index = tmp_idx;
	    new_l_ptr->next = NULL;
	    t_ptr = new_l_ptr;

	    if (c & 0x40) break;
	    c = egetc(fd);
	}

	return (p_ptr);
    } else { /* νƵ */
	new_ptr = pat_malloc_node();
	new_ptr->checkbit = ((c << 8) | egetc(fd)) - 1; /* åӥå */
#if 0
	printf("#cb %d\n",new_ptr->checkbit);
#endif
	(new_ptr->il).index = -1;
	new_ptr->left = pat_load_anode(new_ptr, fd);
	new_ptr->right = pat_load_anode(p_ptr, fd);
	return (new_ptr);
    }
}

/******************************************************
* pat_com_l --- ڤΥ
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼֤
*   ʤ
******************************************************/
static void pat_com_l(char *fname_pat, pat_node *ptr)
{
    int fd;

#if 0
    fprintf(stderr, "# Loading pat-tree \"%s\" ... ",fname_pat);
#endif

    if ((fd = open(fname_pat, O_RDONLY | O_BINARY)) == -1) {
	fprintf(stderr, "can't open %s\n",fname_pat);
	exit(1);
    }
    ptr->right = pat_load_anode(ptr, fd);
    close(fd);
#if 0
    fprintf(stderr,"done.\n");
#endif
}

/****************************************************
* save_pat --- ѥȥꥷڥǡ򥻡 
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼
*   top_ptr --- ϥΡɤΰ(ݥ)
*   out_to --- (stdoutե)
* 
* ֤
*   ̵ѥȥꥷڥǡϡ
*
* ϥեޥå --- 8ӥåȤ˶ڤäƥХʥ
*   ͥõϥåӥåȡϥǥå
*   åӥå --- ŪˤΤޤ ( 0 ӥåȤ 0)
*      -1 ΤȤΤ 1 ­
*   ǥå ---  0 ӥåȤ 1 ˤ
****************************************************/
static void save_pat(pat_node *top_ptr, int fd)
{
    pat_index_list *ptr;

    /* νåӥåȤ */
    eputc (((top_ptr->checkbit + 1)>> 8) & 0x7f, fd);
    eputc ((top_ptr->checkbit + 1)& 0xff, fd);

    /*  Subtree νդäѤʤ饤ǥåϡ
       դäѤǤʤкƵ*/
    if (top_ptr->checkbit < top_ptr->left->checkbit)
	save_pat(top_ptr->left, fd);
    else {
	ptr = &(top_ptr->left->il);
	if (ptr->index < 0) 
	    dummy(fd);
	else {
	    while (ptr != NULL) {
		if (ptr->next == NULL)
		    eputc (((ptr->index >> 24) & 0x3f) | 0xc0, fd);
		else
		    eputc (((ptr->index >> 24) & 0x3f) | 0x80, fd);
		eputc ((ptr->index >> 16) & 0xff, fd);
		eputc ((ptr->index >> 8) & 0xff, fd);
		eputc ((ptr->index) & 0xff, fd);
		ptr = ptr->next;
	    }
	}
    }
    if (top_ptr->checkbit < top_ptr->right->checkbit)
	save_pat(top_ptr->right, fd);
    else {
	ptr = &(top_ptr->right->il);
	if (ptr->index < 0) dummy(fd);
	else {
	    while (ptr != NULL) {
		if (ptr->next == NULL)
		    eputc (((ptr->index >> 24) & 0x3f) | 0xc0, fd);
		else
		    eputc (((ptr->index >> 24) & 0x3f) | 0x80, fd);
		eputc ((ptr->index >> 16) & 0xff, fd);
		eputc ((ptr->index >> 8) & 0xff, fd);
		eputc ((ptr->index) & 0xff, fd);
		ptr = ptr->next;
	    }
	}
    }
}

/*****************************************************
* pat_com_s --- ڤΥ 
*  by û(keiji-y@is.aist-nara.ac.jp)
*
* ѥ᡼֤
*   ʤ
*****************************************************/
static void pat_com_s(char *fname_pat, pat_node *ptr)
{
    int i, fd;

    printf("Saving pat-tree \"%s\" ...\n",fname_pat);
    fd = open(fname_pat, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0644);
    if (fd < 0) {
	fprintf(stderr, "can't open %s\n", fname_pat);
	exit(1);
    }; 
    save_pat(ptr->right, fd); /* ե */
    for (i = 0; i < PAT_BUFSIZ; i++)
	eputc(0, fd); /* flush */
    close(fd);
}

/******************************************************
* pat_init_tree_top --- ѥȥꥷڤκν
*
* ѥ᡼
*   ptr --- ڤκؤΥݥ
******************************************************/
static void pat_init_tree_top(pat_node *ptr)
{
    (ptr->il).index = -1; /* ǥåΥꥹ */
    ptr->checkbit = -1;
    ptr->right = ptr;
    ptr->left = ptr;
}
