/*
==============================================================================
	zentohan.c
		1991/01/08/Tue	Yutaka MYOKI(Nagao Lab., KUEE)
		1991/01/08/Tue	Last Modified
==============================================================================
*/

#include <stdio.h>
#include <string.h>
#ifdef KOCHA2
#include "kcode.h"
#endif

#define iskanji(x) ((unsigned char)(x) & 0x80)

#ifdef SJIS

/***********************************************************************
 *  euc->sjis, sjis->euc hankakukana->zenkaku code translation 
 ***********************************************************************/
unsigned char *euc2sjis(str)
    unsigned char *str;
{
    unsigned char *s;
    for(s=str;*s;s++){
        if (*s>=0x80){
            if (*s & 1) {
                *(s+1) -= 0x61;
                if (*(s+1) >= 0x7f) (*(s+1))++;
            } else *(s+1) -= 2;

            *s = ((*s + 1) >> 1) + 0x30;
            if (*s >= 0xa0) *s += 0x40;
            s++;
        }
    }
    return str;
}

/***********************************************************************
 * hankana2zenkana1
 *
 * return code: ȤΥݥ󥿤ɬפ˱ƿʤ᤿ݥ
 ***********************************************************************/
static unsigned char *hankana2zenkana1(moto, ato)
    unsigned char *moto, *ato;
{
    static unsigned char hankaku[] =
    {0x81, 0x42, 0x81, 0x75, 0x81, 0x76, 0x81, 0x41, 0x81, 0x45, 0x83, 0x92,
     0x83, 0x40, 0x83, 0x42, 0x83, 0x44, 0x83, 0x46, 0x83, 0x48, 0x83, 0x83,
     0x83, 0x85, 0x83, 0x87, 0x83, 0x62, 0x81, 0x5b, 0x83, 0x41, 0x83, 0x43,
     0x83, 0x45, 0x83, 0x47, 0x83, 0x49, 0x83, 0x4a, 0x83, 0x4c, 0x83, 0x4e,
     0x83, 0x50, 0x83, 0x52, 0x83, 0x54, 0x83, 0x56, 0x83, 0x58, 0x83, 0x5a, 
     0x83, 0x5c, 0x83, 0x5e, 0x83, 0x60, 0x83, 0x63, 0x83, 0x65, 0x83, 0x67,
     0x83, 0x69, 0x83, 0x6a, 0x83, 0x6b, 0x83, 0x6c, 0x83, 0x6d, 0x83, 0x6e,
     0x83, 0x71, 0x83, 0x74, 0x83, 0x77, 0x83, 0x7a, 0x83, 0x7d, 0x83, 0x7e,
     0x83, 0x80, 0x83, 0x81, 0x83, 0x82, 0x83, 0x84, 0x83, 0x86, 0x83, 0x88,
     0x83, 0x89, 0x83, 0x8a, 0x83, 0x8b, 0x83, 0x8c, 0x83, 0x8d, 0x83, 0x8f,
     0x83, 0x93, 0x81, 0x4a, 0x81, 0x4b};

    unsigned char *p, *s;
    int dakuten;

    p = ato;
    s = moto;
    if (*(s+1) == 0xde && 
	(*s>=0xb6 && *s<=0xc4 || *s>=0xca && *s<=0xce))
      dakuten = 1;
    else if (*(s+1) == 0xdf && *s>=0xca && *s<=0xce)
      dakuten = 2;
    else
      dakuten = 0;
    *p++ = hankaku[(*s - 0xa1) * 2];
    *p++ = hankaku[(*s - 0xa1) * 2 + 1] + dakuten;
    if (dakuten){
	s++;
    }
    return s;
}

unsigned char *hankana2zenkana(str)
    unsigned char *str;
{
    unsigned char tmp[8192 /*CHA_INPUT_SIZE*/], *p, *s;

    p = tmp;
    for (s = str; *s; s++){
        if ((0x80 <= *s && *s < 0xa0) || (0xe0 <= *s && *s <= 0xfc)) {
            *p++ = *s++;
            *p++ = *s;
        } else if (0xa1<=*s && *s<=0xdf) {
	    s=hankana2zenkana1(s,p);
	    p+=2;
        } else {
            *p++ = *s;
        }
    }
    *p = '\0';
    strcpy(str, tmp);
    return str;
}


static void sjis2euc1(hi, lo)
    unsigned char *hi, *lo;
{
    if (*hi >= 0xe0) (*hi) -= 0x40;
    *hi = ((*hi - 0x30) << 1);
    
    if (*lo >= 0x9f) (*lo) += 2;
    else {
	(*hi)--;
	if (*lo >= 0x80) (*lo) += 0x60;
	else (*lo) += 0x61;
    }
}


unsigned char *sjis2euc(str)
    unsigned char *str;
{
    unsigned char tmp[8192 /*CHA_INPUT_SIZE*/], *p, *s;

    if (!str[0])
      return str;

    p = tmp;
    for (s = str; *s; s++){
        if ((0x80 <= *s && *s < 0xa0) || (0xe0 <= *s && *s <= 0xfc)) {
            *p++ = *s++;
            *p++ = *s;
	    sjis2euc1(p-2,p-1);
        } else if (0xa1<=*s && *s<=0xdf) {
	    s=hankana2zenkana1(s,p);
	    p+=2;
	    sjis2euc1(p-2,p-1);
        } else {
            *p++ = *s;
        }
    }
    *p = '\0';
    strcpy(str, tmp);
    return str;
}

#endif /* SJIS */

#ifdef KOCHA2
static int jaso2ks1(s)
    unsigned char *s;
{
    int i;
    if (*s != 0xa4) return -1;
    for (i = 0; i < 2350; i++) {
	if (!strcmp(s, ksjaso[i])) {
	    i = (int)(i / 94) * 0x100 + (i % 94) + 0xb0a1; 
	    s[0] = i / 0x100;
	    s[1] = i % 0x100;
	    s[2] = '\0';
	    return i;
	}
    }
    return -1;
}

char *is_moeum(s1)
    char *s1;
{
    int i;
    char *s2;
    static char moeum[] = "¤äĤŤƤǤȤɤʤˤ̤ͤΤϤФѤҤ";
    for (s2 = moeum; *s2; s2 += 2) {
	if (s1[0] == s2[0] && s1[1] == s2[1]) return s2;
    }
    return NULL;
}    

/*
 * translation JASO to KS C 5601 97/03/19 04:32:28
 */
jaso2ks(str)
    unsigned char *str;
{
    int fl, i;
    unsigned char outstr[8192], buf[20], *in, *out, *stk, bak[2];
    
    int tbl[][6] = {{1, 0, 0, 0, 0, 0}, {1, 2, 3, 4, 4, 4},
		      {5, 0, 0, 4, 0, 0}, {5, 0, 0, 0, 4, 0},
		      {5, 0, 0, 0, 0, 0}, {1, 2, 3, 4, 4, 4}};
    
    for (in = str, out = outstr, fl = 0, stk = buf; *in && in ;in++) {
	if (*in < 0xa1) {
	    *stk = '\0';
	    jaso2ks1(buf);
	    strcpy(out, buf);
	    out += strlen(buf);
	    stk = buf;
	    *out++ = *in;
	    fl = 0;
	}
	else if (*in == 0xa4 && 0xa1 <= in[1] && in[1] <= 0xd3) { 
	    /* if jaso */
	    if (!is_moeum(in)) {
		switch (fl) {
		  case 1:
		  case 5:
		    *stk = '\0';
		    jaso2ks1(buf);
		    strcpy(out, buf);
		    out += strlen(buf);
		    stk = buf;
		    break;
		}
		fl = tbl[fl][0];
		*stk++ = in[0];
		*stk++ = in[1];
	    } else {
		if ((fl == 2 && in[1] == (unsigned char)""[1])
		    || (fl == 3 && in[1] == (unsigned char)""[1])) {
		    *stk++ = in[0];
		    *stk++ = in[1];
		} else 
		    switch(fl) {
		      case 2:
		      case 3:
		      case 4:
			*stk = '\0';
			strcpy(out, buf);
			out += strlen(buf);
			stk = buf;
			*out++ = in[0];
			*out++ = in[1];
			break;
		      case 5:
			bak[0] = stk[-2];
			bak[1] = stk[-1];
			stk[-2] = '\0';
			jaso2ks1(buf);
			strcpy(out, buf);
			out += strlen(buf);
			stk = buf;
			*stk++ = bak[0];
			*stk++ = bak[1];
		      default:
			*stk++ = in[0];
			*stk++ = in[1];
		    }
		if (in[1] == (unsigned char)""[1]) 
		    fl = tbl[fl][1];
		else if (in[1] == (unsigned char)""[1] 
			 || in[1] == (unsigned char)""[1] 
			 || in[1] == (unsigned char)""[1])
		    fl = tbl[fl][2];
		else if (in[1] == (unsigned char)""[1])
		    fl = tbl[fl][3];
		else if (in[1] == (unsigned char)""[1])
		    fl = tbl[fl][4];
		else 
		    fl = tbl[fl][5];
	    }
	    in++;
	} else {
	    *stk = '\0';
	    jaso2ks1(buf);
	    strcpy(out, buf);
	    out += strlen(buf);
	    stk = buf;
	    if (in[0] == 0xa1 && in[1] == 0xa1) {
		*out++ = ' ';
		in++;
	    } else {
		*out++ = *in++;
		*out++ = *in;
	    }
	    fl = 0;
	}
    }
    if (stk != buf) { 
	*stk = '\0';
	jaso2ks1(buf);
	strcpy(out, buf);
    } else {
	    *out = '\0';
	}
    fl = 0;
    strcpy(str, outstr);
}

/*
 * translation KS C 5601 to JASO 97/03/2 06:52:29
 */
unsigned char *ks2jaso(input, output)
    unsigned char *input;
    unsigned char *output;
{
    unsigned char *in, *out, *p;
    unsigned int i;
    static unsigned char sp[3] = "";
    
    for (in = input, out = output; in && *in; in++) {
	if (*in >= 0xa1){
	    i = (in[0] - 0xb0) * 94 + (in[1] - 0xa1);
	    if (0 <= i && i < 2350){
		for (p = ksjaso[i]; p && *p; p++, out++)
		  *out = *p;
	    }else{
		*out++ = in[0];
		*out++ = in[1];
	    }
	    in++;
	}else{
	    if (*in == ' ') {
		*out++ = sp[0];
		*out++ = sp[1];
	    }
	    else *out++ = *in;
	}
    }
    *out = '\0';
    return output;
}
#endif /* KOCHA2 */

