/*-
 * getid.c
 *
 * Copyright (c) 2000 Nara Institute of Science and Technology
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Nara Institute of 
 *      Science and Technology.
 * 4. The name Nara Institute of Science and Technology may not be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *    
 *
 * THIS SOFTWARE IS PROVIDED BY Nara Institute of Science and Technology 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE Nara Institute
 * of Science and Technology BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: getid.c,v 1.3.4.1 2000/12/18 20:08:31 masayu-a Exp $
 */
#include "chadic.h"

int cha_get_nhinsi_str_id(hinsi)
    char **hinsi;
{
    int id, i, d;

    if (!*hinsi)
      cha_exit_file(1, "an empty string for hinsi");

    for (id = 0; *hinsi; hinsi++) {
	if (!**hinsi)
	  cha_exit_file(1, "an empty string for hinsi");
	for (i = 0; (d = Cha_hinsi[id].daughter[i]) != 0; i++) {
	    if (!strcmp(Cha_hinsi[d].name, *hinsi))
	      break;
	}
	if (!d){
	    cha_exit_file(1, "hinsi `%s' is undefined", *hinsi);
	    /* return 0; 970301 tatuo: ꤢ 0 ֤ */
	}
	id = d;
    }

    return id;
}

int cha_get_nhinsi_id(cell)
    chasen_cell_t *cell;
{
    char *hinsi_str[256];
    char **hinsi = hinsi_str;

    for (; !nullp(cell); cell = cha_cdr(cell))
      *hinsi++ = cha_s_atom(cha_car(cell));

    *hinsi = NULL;

    return cha_get_nhinsi_str_id(hinsi_str);
}

int cha_get_type_id(x)
    char *x;
{
    int i;

    if (x==NULL) {
	cha_exit_file(1, "null string for type");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    for (i = 1; strcmp(Cha_type[i].name, x); ) {
	if (!Cha_type[++i].name) {
	    cha_exit_file(1, "type `%s' is undefined", x);
	    /* return 255; 970301 tatuo: ꤢ 255 ֤() */	
	}
    }

    return i;
}

int cha_get_form_id(x, type)
    char *x;
    int type;
{
    int i;

    if (x == NULL) {
	cha_exit_file(1, "null string for form");
	return 0;
    }

    if (x[0] == '*' && x[1] == '\0')
      return 0;

    if (type == 0) {
	cha_exit_file(1, "Invalid type number for type `%s'", x);
	return 0;
    }

    for (i = 1; strcmp(Cha_form[type][i].name, x); ) {
	if (!Cha_form[type][++i].name) {
	    cha_exit_file(1, "type `%s' has no katuyou `%s'", Cha_type[type].name, x);
	    return 0;
	}
    }

    return i;
}

