/*-
 *                                                 
 * sufary.h - SUFARY饤֥إåե
 * SUFARY --- Suffix Array ΤΥ饤֥  
 *
 * Copyright (c) 1996, 1997, 2000 Nara Institute of Science and Technology
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Nara Institute of 
 *      Science and Technology.
 * 4. The name Nara Institute of Science and Technology may not be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *    
 *
 * THIS SOFTWARE IS PROVIDED BY Nara Institute of Science and Technology 
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE Nara Institute
 * of Science and Technology BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: sufary.h,v 1.8.4.1 2000/12/18 20:08:31 masayu-a Exp $
 */

#ifndef _SUFARY_H_
#define _SUFARY_H_

#include "config.h"
#include <sys/types.h>

#ifndef KEYWORD_MAX_LENGTH
#define KEYWORD_MAX_LENGTH 5000
#endif

/* ޥɤ */
typedef enum eresult_{
  CONT,
  FAIL,
  EXIT,
  ERROR
} eresult;

/* 顼 */
typedef enum eerror_ {
  NOERROR,
  COMMAND,
  MEMORY,
  FILEIN,
  FILEOUT,
  STRUCTURE,
  UNKNOWN
} eerror;

/* SUFARY¤ */
typedef struct {
  eerror ee;      /* Х륨顼ɤݻ */
  long arraysize; /* Array 礭 */
  long left;  /* ϰϤκü(ϰϤ¦ؤ)   g_bottom */
  long right;     /* ϰϤαü(ϰϤ¦ؤ)   g_top */
  off_t txtsz;    /* ƥȥեΥ */
  off_t arysz;    /* 쥤եΥ */
  void *txtmap; /* ƥȥեΥޥåץɥ쥹 */
  void *arymap; /* 쥤եΥޥåץɥ쥹 */
} SUFARY;

/* ץȥ ѥ롼 */
/*** select.c ***/
char **sa_common_prefix_search();

/*** chfile.c ***/
SUFARY *sa_openfiles();
void sa_closefiles();

#endif /* _SUFARY_H_ */
