<?php
require_once('./common.php');

function init() {
  $r = array();
  array_push($r, initMessages());
  array_push($r, getTitle());
  array_push($r, getBody64('all', ''));
  array_push($r, getBody64('closeBox', ''));
  array_push($r, getBody64('deleteBox', ''));
  array_push($r, getStarter());
  array_push($r, getBody64('css', ''));
  array_push($r, DATAURI);
  array_push($r, ATTACH);
  if('' != $_SERVER['QUERY_STRING'] && is_dir(DATADIR.str_replace('%', '.', $_SERVER['QUERY_STRING']))) {
    array_push($r, urldecode($_SERVER['QUERY_STRING']));
  }
  else {
    array_push($r, '');
  }
  $plugins = array();
  $dh = opendir('plugins');
  while(($file = readdir($dh)) !== false) {
    if(preg_match("/.js$/i", $file)) {
      $fh = fopen('plugins/'.$file, 'rb');
      $body = base64_encode(fread($fh, filesize('plugins/'.$file)));
      $plugins[substr($file, 0, strlen($file) - 3)] = $body;
      fclose($fh);
      continue;
    }
  }
  closedir($dh);
  array_push($r, $plugins);
  array_push($r, getBody64('editForm', ''));

  $caches = array();
  $str = getBody('cache', '');
  eval($str);
  while($name = array_shift($cache)) {
    $body = getBody64($name, '');
    if('' == $body) continue;
    $code = getCode64($name, '');
    $target = getTarget($name);
    $public = getPublic($name);
    array_push($caches, array($name, $body, $code, $target, $public));
  }
  array_push($r, $caches);

  $list = listContents('');
  array_push($r, $list);

  array_push($r, getBody64('contentsList', ''));
  array_push($r, getBody64('shadowList', ''));

  $handle = fopen('history.php', 'rb');
  $hstr = fread($handle, filesize('history.php'));
  fclose($handle);
  $history = split("\n", $hstr);
  $hlist = array();
  while($line = array_shift($history)) {
    $i = strpos($line, '|');
    array_push($hlist, array(substr($line, 0, $i), substr($line, $i + 1)));
  }
  array_push($r, $hlist);

  return $r;
}

function show($name, $auth, $target, $doCode) {
  $r = array();
  $target_org = getTarget($name);
  if('undefined' == $target) {
    $target = $target_org;
  }
  $public = getPublic($name);
  array_push($r, $name);
  array_push($r, getBody64($name, $auth));
  array_push($r, getCode64($name, $auth));
  array_push($r, $target);
  array_push($r, $doCode);
  array_push($r, $public);
  array_push($r, $target_org);
  return $r;
}

function getBody($name, $auth) {
  return getFile('body.php', $name, $auth);
}

function getBody64($name, $auth) {
  return base64_encode(getBody($name, $auth));
}

function getCode64($name, $auth) {
  return base64_encode(getFile('code.php', $name, $auth));
}

function getFile($type, $name, $auth) {
  $uname = dirEncode($name);
  if(file_exists(DATADIR.$uname.'/property.php')) {
    include(DATADIR.$uname.'/property.php');
    $public = $property['public'];
  }
  else {
    $public = 1;
  }
  if(!auth($auth)  && 1 != $public) {
    // 認証NGでpublic=0だったら、空bodyを返す
    return '';
  }
  $filename = DATADIR.$uname.'/'.$type;
  if(!(file_exists($filename))) {
    return '';
  }
  $handle = fopen($filename, 'rb');
  $str = fread($handle, filesize($filename));
  fclose($handle);
  // '<?php /*'と'*/ ?_>'を取り除く
  $str = substr($str, 8, strlen($str) - 13);
  return $str;
}

function getTarget($name) {
  $uname = dirEncode($name);
  if(file_exists(DATADIR.$uname.'/property.php')) {
    include(DATADIR.$uname.'/property.php');
    return $property['target'];
  }
  else {
    return 'main';
  }
}

function getPublic($name) {
  $uname = dirEncode($name);
  if(file_exists(DATADIR.$uname.'/property.php')) {
    include(DATADIR.$uname.'/property.php');
    return $property['public'];
  }
  else {
    return 1;
  }
}

function getShadow($name) {
  $uname = dirEncode($name);
  if(file_exists(DATADIR.$uname.'/property.php')) {
    include(DATADIR.$uname.'/property.php');
    return $property['shadow'];
  }
  else {
    return 0;
  }
}

function getStarter() {
  $str = getBody('starter', '');
  eval($str);
  return $starter;
}

function initMessages() {
  $str = getBody('messages', '');
  eval($str);
  return $message;
}

function getTitle() {
  $str = getBody('title', '');
  eval($str);
  return $title;
}

function login($pw) {
  $r = array();
  $a = '';
  if(checkPassword($pw)) {
    $a = md5(date('ymdHis'));
    $handle = fopen('./auth.php', 'wb');
    fwrite($handle, "<?php\n\$auth = '".$a."';\n?>");
    fclose($handle);
  }
  $list = listContents($a);
  array_push($r, $a);
  array_push($r, $list);
  return $r;
}

function checkPassword($pw) {
  include('./password.php');
  if('' == $password || md5($pw) == $password) {
    return true;
  }
  else {
    return false;
  }
}

function changePassword($old, $new) {
  $a = '';
  if(checkPassword($old)) {
    $a = md5(date('ymdHis'));
    $handle = fopen('./auth.php', 'wb');
    fwrite($handle, "<?php\n\$auth = '".$a."';\n?>");
    fclose($handle);
    $handle = fopen('./password.php', 'wb');
    fwrite($handle, "<?php\n\$password = '".md5($new)."';\n?>");
    fclose($handle);
  }
  return $a;
}

function listAttached($name) {
  $attached = array();
  $path = DATAURI.dirEncode($name).ATTACH;
  if(is_dir($path) && $handle = opendir($path)) {
    while ($file = readdir($handle)) {
      if ($file != '.' && $file != '..') {
        array_push($attached, $file);
      } 
    }
    closedir($handle); 
  }
  if(0 < count($attached)) {
    array_unshift($attached, $name);
  }
  return $attached;
}

function edit($name, $auth) {
  $r = array();
  array_push($r, getBody64($name, $auth));
  array_push($r, getCode64($name, $auth));
  array_push($r, getTarget($name));
  array_push($r, getPublic($name));
  return $r;
}

function save($name, $body, $code, $target, $public, $auth) {
  if(!auth($auth)) {
    return 'error1';
  }
  $path = DATADIR.dirEncode($name);
  $shadow = 0;
  if(is_dir($path)) {
    if(file_exists($path.'/property.php')) {
      include($path.'/property.php');
      $shadow = $property['shadow'];
    }
  }
  else {
    mkdir($path);
  }
  if(!$handle = fopen($path.'/body.php', 'wb')) {
    return 'error2';
  }
  $body = str_replace(' ', '+', $body);
  $body = base64_decode($body);
  if(!fwrite($handle, '<?php /*'.$body.'*/ ?>')) {
    close($handle);
    return 'error2';
  }
  fclose($handle);
  if(!$handle = fopen($path.'/code.php', 'wb')) {
    return 'error2';
  }
  $body = str_replace(' ', '+', $body);
  $code = base64_decode($code);
  if(!fwrite($handle, '<?php /*'.$code.'*/ ?>')) {
    close($handle);
    return 'error2';
  }
  fclose($handle);
  if(!$handle = fopen($path.'/property.php', 'wb')) {
    return 'error2';
  }
  $pr = "<?php\n"
        .'$property = array('."\n"
        ."'target' => '$target',\n"
        ."'public' => $public,\n"
        ."'shadow' => $shadow\n"
        .");\n"
        ."?>";
  if(!fwrite($handle, $pr)) {
    close($handle);
    return 'error2';
  }
  fclose($handle);

  if(1 == $shadow) return 'success';
  if(0 == $public) {
    deleteHistory($name);
    return 'success';
  }

  if(saveHistory($name)) return 'success';
  else return 'error2';
}

function saveHistory($name) {
  $filename = 'history.php';
  $history = array();
  if(file_exists($filename)) {
    $handle = fopen($filename, 'rb');
    $hstr = fread($handle, filesize($filename));
    fclose($handle);
    $h = split("\n", $hstr);
    while($item = array_shift($h)) {
      if(($i = strpos($item, '|')) && substr($item, 0, $i) == $name) continue;
      array_push($history, $item);
    }
  }
  if(!$handle = fopen($filename, 'wb')) {
    return false;
  }
  array_unshift($history, $name.'|'.date('r'));
  if(10 < count($history)) array_pop($history);
  $hstr = implode("\n", $history);
  fwrite($handle, $hstr);
  fclose($handle);

  return true;
}

function deleteHistory($name) {
  $filename = 'history.php';
  $history = array();
  if(file_exists($filename)) {
    $handle = fopen($filename, 'rb');
    $hstr = fread($handle, filesize($filename));
    fclose($handle);
    $h = split("\n", $hstr);
    while($item = array_shift($h)) {
      if(($i = strpos($item, '|')) && substr($item, 0, $i) == $name) continue;
      array_push($history, $item);
    }
  }
  if(!$handle = fopen($filename, 'wb')) {
    return false;
  }
  $hstr = implode("\n", $history);
  fwrite($handle, $hstr);
  fclose($handle);

  return true;
}

function renameHistory($oldname, $newname) {
  $filename = 'history.php';
  $history = array();
  if(file_exists($filename)) {
    $handle = fopen($filename, 'rb');
    $hstr = fread($handle, filesize($filename));
    fclose($handle);
    $h = split("\n", $hstr);
    while($item = array_shift($h)) {
      if(($i = strpos($item, '|')) && substr($item, 0, $i) == $oldname) {
        $item = $newname.'|'.substr($item, $i + 1);
      }
      array_push($history, $item);
    }
  }
  if(!$handle = fopen($filename, 'wb')) {
    return false;
  }
  $hstr = implode("\n", $history);
  fwrite($handle, $hstr);
  fclose($handle);

  return true;
}

function deleteAttached($name, $file, $auth) {
  $r = array($name);
  if(!auth($auth)) {
    array_unshift($r, 'error1');
    return $r;
  }
  if(unlink(DATADIR.dirEncode($name).ATTACH.$file)) {
    array_unshift($r, 'success');
    return $r;
  }
  else {
    array_unshift($r, 'error2');
    return $r;
  }
}

function listContents($auth) {
  $a = auth($auth);
  $list = array();
  $dh1 = opendir(DATADIR);
  while(($dir = readdir($dh1)) !== false) {
    if ($dir != '.' && $dir != '..') {
      $name = dirDecode($dir);
      $pub = getPublic($name);
      $shadow = getShadow($name);
      if(($a || 1 == $pub) && 0 == $shadow) {
        array_push($list, $name);
      }
    }
  }
  closedir($dh1);
  sort($list);
  return $list;
}

function listShadows($auth) {
  $list = array();
  if(!auth($auth)) {
    return $list;
  }
  $dh = opendir(DATADIR);
  while(($dir = readdir($dh)) !== false) {
    if($dir != '.' && $dir != '..') {
      $name = dirDecode($dir);
      $shadow = getShadow($name);
      if(1 == $shadow) {
        array_push($list, $name);
      }
    }
  }
  closedir($dh);
  sort($list);
  return $list;
}

function deleteContent($name, $auth) {
  $r = array($name);
  if(!auth($auth)) {
    array_unshift($r, 'error1');
    return $r;
  }
  $dir = DATADIR.dirEncode($name);
  if(is_dir($dir.ATTACH)) {
    $dh = opendir($dir.ATTACH);
    while($file = readdir($dh)) {
      if($file != '.' && $file != '..') {
        unlink($dir.ATTACH.$file);
      }
    }
    closedir($dh);
    rmdir($dir.ATTACH);
  }
  $dh = opendir($dir);
  while($file = readdir($dh)) {
    if($file != '.' && $file != '..') {
      unlink($dir.'/'.$file);
    }
  }
  closedir($dh);
  if(rmdir($dir)) {
    array_unshift($r, 'success');
    deleteHistory($name);
  }
  else {
    array_unshift($r, 'error2');
  }
  return $r;
}

function renameContent($oldname, $newname, $auth) {
  if(!auth($auth)) return '';
  if(file_exists(DATADIR.dirEncode($newname))) {
    return '';
  }
  if(rename(DATADIR.dirEncode($oldname), DATADIR.dirEncode($newname))) {
    renameHistory($oldname, $newname);
    return $newname;
  }
  else {
    return '';
  }
}

function copyContent($name, $offset, $auth) {
  $r = array($name);
  $newName = $name.gmdate('Ymd-His', gmdate('U') - $offset * 60);
  $newDir = DATADIR.dirEncode($newName);
  if(!auth($auth) || !dirCopy(DATADIR.dirEncode($name), $newDir)) {
    array_unshift($r, '');
    return $r;
  }
  else {
    include($newDir.'/property.php');
    if(!$fh = fopen($newDir.'/property.php', 'wb')) {
      array_unshift($r, '');
      return $r;
    }
    $target = $property['target'];
    $shadow = $property['shadow'];
    $pr = "<?php\n"
          .'$property = array('."\n"
          ."'target' => '$target',\n"
          ."'public' => 0,\n"
          ."'shadow' => $shadow\n"
          .");\n"
          ."?>";
    if(!fwrite($fh, $pr)) {
      close($handle);
      array_unshift($r, '');
      return $r;
    }
    fclose($fh);
    array_unshift($r, $newName);
    return $r;
  }
}

function dirCopy($from, $to) {
  if(!file_exists($from)) return false;
  if(file_exists($to)) return false;
  if(!mkdir($to)) return false;
  $dh = opendir($from);
  while($file = readdir($dh)) {
    if($file != '.' && $file != '..') {
      if(is_dir($from.'/'.$file)) {
        if(!dirCopy($from.'/'.$file, $to.'/'.$file)) return false;
      }
      else {
        if(!copy($from.'/'.$file, $to.'/'.$file)) return false;
      }
    }
  }
  closedir($dh);
  return true;
}

function listCopies($name) {
  $list = array();
  $org = dirEncode($name);
  $dh = opendir(DATADIR);
  while(($dir = readdir($dh)) !== false) {
    if(preg_match("/^$org".'[0-9]{8}\-[0-9]{6}$/', $dir)) {
      array_push($list, dirDecode($dir));
    }
  }
  closedir($dh);
  sort($list);
  return $list;
}

include_once("agent.php");
$agent->init(); 

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
<meta http-equiv="content-type" content="text/html;charset=UTF-16">
<script language="JavaScript" src="utf.js"></script>
<script language="JavaScript" src="base64.js"></script>
<script language="JavaScript" src="wikify.js"></script>
<script language="JavaScript" src="choiwiki.js"></script>
<title></title>
<style>
  p { font-size: 12px; font-family: Verdana, Arial; }; 
</style>
</head>
<body onLoad=init()>
<div id="all">reading...<br/>
This page is only available for IE.</div>
</body>
</html>
