#ifndef __HADDOCK__
-- $Id: Rot13.hs,v 1.5 2007/01/14 08:54:30 ha-tan Exp $
#endif
module Cinnamon.Rot13 (rot13) where

import Data.Char (chr, ord)

-- | 文字列をROT13変換します。
-- 参照: <http://ja.wikipedia.org/wiki/ROT13>
rot13 :: String -> String
rot13 = map (chr . conv . ord)
  where
    conv :: Int -> Int
    conv i
      | (i >= ord 'a') && (i <= ord 'm') = i + 13
      | (i >= ord 'n') && (i <= ord 'z') = i - 13
      | (i >= ord 'A') && (i <= ord 'M') = i + 13
      | (i >= ord 'N') && (i <= ord 'Z') = i - 13
      | otherwise                        = i
