#!/usr/bin/perl -w

use strict;
use File::Basename;
use vars qw(
	$SrcDir
	@Options
);

sub Select {
	my	($desc, $defaultNum, @list) = @_;
	my	$selected = undef;
	my	$failedTime = 0;

	while (!defined($selected) and $failedTime < 3) {
		my	$inputed;
		my	$i;

		print $desc,"\n";
		for ($i = 0; $i < scalar(@list); $i++) {
			printf "[%d] %s\n", $i+1, $list[$i]->{name};
		}

		print "Input number and type enter key";
		printf ' [%d]', $defaultNum	if ($defaultNum);
		print ': ';
		$inputed = <STDIN>;

		chomp $inputed;
		$inputed =~ s/^\s*(\S*)\s*$/$1/;
		if ($inputed =~ m/^[1-9]\d*$/) {
			if ($inputed <= $i) {
				$selected = $inputed;
			}
			else {
				printf "Available range is 1 to %d.\n", scalar(@list);
				$failedTime++;
			}
		}
		elsif ($defaultNum and $inputed eq '') {
			$selected = $defaultNum;
		}
		else {
			print "You can input only integer.\n";
			$failedTime++;
		}
		print "\n";
	}

	return $list[$selected-1]->{value}	if ($failedTime < 3);

	printf "Give up because it failed three times.\n";
	return undef;
}

if (! -d '/Applications/ClamXav.app') {
	print STDERR "ClamXav is not installed. Use install.sh\n";
	exit(1);
}

$SrcDir = dirname($0);
@Options = qw(--verbose --admin-group=admin --prefix=/usr/local/clamXav --clamav-prefix=/usr/local/clamXav);

if (-d '/Library/StartupItems/ClamAntiVirusDaemon') {
	push @Options, '--clamd',
		'--clamd-restart=[qw(/Library/StartupItems/ClamAntiVirusDaemon/ClamAntiVirusDaemon restart)]'
	;
}
if (-d '/Library/StartupItems/FreshClamDaemon') {
	push @Options, '--freshclam',
		'--freshclam-restart=[qw(/Library/StartupItems/FreshClamDaemon/FreshClamDaemon restart)]'
	;
}

{
	my	$donwloadFrom;

	$donwloadFrom = Select("Select ClamAV mirror site", 1,
		{
			name	=> 'Asia: Ishikawa, Japan',
			value	=> 'http://jaist.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Asia: Tainan, Taiwan',
			value	=> 'http://nchc.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Australia: Sydney, Australia',
			value	=> 'http://optusnet.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Europe: Amsterdam, The Netherlands',
			value	=> 'http://surfnet.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Europe: Brussels, Belgium',
			value	=> 'http://belnet.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Europe: Dublin, Ireland',
			value	=> 'http://heanet.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Europe: Duesseldorf, Germany',
			value	=> 'http://mesh.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Europe: Kent, UK',
			value	=> 'http://kent.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Europe: Lausanne, Switzerland',
			value	=> 'http://switch.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'Europe: Paris, France',
			value	=> 'http://ovh.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'North America: McLean, Virginia',
			value	=> 'http://superb-east.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'North America: Minneapolis, MN',
			value	=> 'http://umn.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'North America: Phoenix, AZ',
			value	=> 'http://easynews.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'North America: Seattle, Washington',
			value	=> 'http://superb-west.dl.sourceforge.net/sourceforge/clamav',
		},
		{
			name	=> 'South America: Curitiba, Brazil',
			value	=> 'http://ufpr.dl.sourceforge.net/sourceforge/clamav',
		},
	);
	exit 2	unless (defined($donwloadFrom));

	unless ($donwloadFrom eq 'http://jaist.dl.sourceforge.net/sourceforge/clamav') {
		push @Options, "--clamav-download-from=$donwloadFrom";
	}

	$donwloadFrom = Select("Select clamav-update mirror site", 1,
		{
			name	=> 'Tokyo Japan: OSDN Japan',
			value	=> 'http://qgpop.dl.sourceforge.jp/clamav-update',
		},
		{
			name	=> 'Keihanna Japan: Kansai Science City Internet Community',
			value	=> 'http://keihanna.dl.sourceforge.jp/clamav-update',
		},
		{
			name	=> 'Fukuoka Japan: Kyushu GigaPOP Project',
			value	=> 'http://qgpop.dl.sourceforge.jp/clamav-update',
		},
	);
	exit 3	unless (defined($donwloadFrom));

	unless ($donwloadFrom eq 'http://qgpop.dl.sourceforge.jp/clamav-update') {
		push @Options, "--download-from=$donwloadFrom";
	}
}

system('sudo', "$SrcDir/install.sh", @Options);
