#!/bin/sh

# $Id: build.sh,v 1.7 2007/02/19 04:05:34 okamura Exp $

# グローバル変数
Version=`sed '1,/<key>CFBundleShortVersionString<\/key>/d' Info.plist | head -1 | sed 's/.*<string>\(.*\)<\/string>.*/\1/'`
WorkDir=/tmp/`basename $0`.$$

# 作業ディレクトリ作成
mkdir -p "${WorkDir}/ClamAntiVirusDaemon-${Version}"
sudo chown root:admin "${WorkDir}/ClamAntiVirusDaemon-${Version}"

# パッケージ作成
sudo chown -R root:wheel Contents/ClamAntiVirusDaemon
sudo packagemaker -build -p "${WorkDir}/ClamAntiVirusDaemon-${Version}/ClamAntiVirusDaemon-${Version}.pkg" -f Contents -s -ds -v -r Resources -i Info.plist -d Description.plist
sudo chown -R `id -u`:`id -g` Contents/ClamAntiVirusDaemon

# ディスクイメージ作成
sudo install -o root -g admin -m 0644 clamd.conf "${WorkDir}/ClamAntiVirusDaemon-${Version}/"
sudo install -o root -g admin -m 0644 changelog.ja.utf-8.txt "${WorkDir}/ClamAntiVirusDaemon-${Version}/"
sudo install -o root -g admin -m 0644 ClamAntiVirusDaemon-update.conf "${WorkDir}/ClamAntiVirusDaemon-${Version}/"
rm -f "ClamAntiVirusDaemon-${Version}.dmg"
sudo hdiutil create -srcfolder "${WorkDir}/ClamAntiVirusDaemon-${Version}" -fs HFS+ -volname "ClamAntiVirusDaemon-${Version}" -uid 0 -gid 80 "ClamAntiVirusDaemon-${Version}.dmg"
sudo chown `id -u`:`id -g` "ClamAntiVirusDaemon-${Version}.dmg"

# 作業ディレクトリ削除
sudo rm -rf "${WorkDir}"
