// =====================================================================
//  $Id: TAliasCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TAliasCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TAliasCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TCommandSpecified.hh"

static const Tstring _name = "alias";
static const Tstring _desc = "without arguments, prints all aliases.\nwith name, prints the alias for name.\nwith name and wordlist, assigns wordlist as the alias of name.";

TAliasCommand::TAliasCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TAliasCommand::~TAliasCommand()
{;}

Tvoid TAliasCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() > 2 ) {
    ShowCommandDetail();
    return;
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();

  if ( ui ) {
    if ( arguments.size() == 0 ) {
      printall();
    } else if ( arguments.size() == 1 ) {
      print( arguments[ 0 ] );
    } else if ( arguments.size() == 2 ) {
      alias( arguments[ 0 ], arguments[ 1 ] );
    }
  }

  return;
}

Tvoid TAliasCommand::printall()
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  const TCommandTable& table = ui -> GetCommandTable();

  for ( Tint i = 0; i < table.GetSize(); i ++ ) {
    if ( table[ i ].IsAliasedCommand() ) {
      Tcout << table[ i ].GetFullName() << " is aliased ";
      Tcout << table[ i ].GetCommand() -> GetCommandName() << "." << Tendl;
    }
  }
  return;
}

Tvoid TAliasCommand::print( const Tstring& name )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  const TCommandTable& table = ui -> GetCommandTable();
  Tstring path = ui -> ModifyPath( name );
  for ( Tint i = 0; i < table.GetSize(); i ++ ) {
    if ( table[ i ].IsAliasedCommand() && table[ i ].GetFullName() == path ) {
      Tcout << table[ i ].GetFullName() << " is aliased ";
      Tcout << table[ i ].GetCommand() -> GetCommandName() << "." << Tendl;
    }
  }
  return;
}

Tvoid TAliasCommand::alias( const Tstring& name, const Tstring& wordlist )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();

  Tstring aliasname = name;
  Tstring realname = wordlist;

  aliasname = ui -> ModifyPath( aliasname );
  Tstring abspath = ui -> ModifyPath( realname );
  TCommandTable& table = ui -> GetCommandTable();


  if ( table.AlreadyExist( aliasname ) || table.AlreadyExistDirectory( aliasname ) ) {
    Tcerr << aliasname << ": already defined." << Tendl;
    return;
  }

  if ( ! table.AlreadyExist( abspath ) ) {
    Tcerr << realname << ": No such file or directory." << Tendl;
    return;
  }

  TCommand* command = ui -> GetCommand( abspath );

  Tint nslash = 0;
  for ( Tsize_t i = 0; i < aliasname.size(); i ++ ) {
    if ( aliasname[ i ] == '/' ) {
      nslash ++;
    }
  }

  Tint depth = TCommandSpecified::tAliasDepth;
  Tbool flag;
  Tstring cname;
  Tstring path;
  if ( nslash > 0 ) {
    flag = Tfalse;
    Tsize_t slashpos = aliasname.rfind( '/' );
    path = aliasname.substr( 0, slashpos );
    cname = aliasname.substr( slashpos + 1, aliasname.size() - slashpos - 1 );
  } else {
    flag = Ttrue;
    cname = aliasname;
    path = "";
  }

  TCommandSpecified spec( cname, aliasname, path, depth, flag, command );
  table.push_back( spec );

  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TAliasCommand)
#endif
