// =====================================================================
/*!
//
//  \file TEventAction.hh
//  \brief This file contains the TEventAction class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TEventAction.hh,v 1.7 2004/03/07 10:30:30 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TEventAction.hh,v $
//  Revision 1.7  2004/03/07 10:30:30  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/03/04 14:53:43  goiwai
//  BeginOfEventAction -> AtFirst
//  EndOfEventAction -> AtLast
//  WaitEvent -> WaitTrigger
//
//  Revision 1.5  2004/01/19 21:09:40  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:56:02  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:18:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TEVENTACTION_HH
#define CLDAQ__TEVENTACTION_HH

#include "Tglobals.h"

class TEvent;
class TReadoutList;
class TRunManager;
class TEventManager;
class TReadoutBook;
class TCrate;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TEventAction
// \brief This is the TEventAction class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TEventAction class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup EventCategory
*/
class TEventAction
{

  protected:
    TRunManager* theRunManager;
    TEventManager* theEventManager;
    TReadoutBook* theReadoutBook;
    TCrate* theCrate;

  public:
    TEventAction();
    virtual ~TEventAction();

  public:
    virtual TReadoutList* WaitTrigger() = 0;

  public:
    virtual Tvoid AtFirst( TEvent& anEvent );
    virtual Tvoid AtLast( TEvent& anEvent );

  public:
    TRunManager* GetRunManager() const;
    TEventManager* GetEventManager() const;
    TReadoutBook* GetReadoutBook() const;
    TCrate* GetCrate() const;
    Tvoid SetRunManager( TRunManager* manager );
    Tvoid SetEventManager( TEventManager* manager );
    Tvoid SetReadoutBook( TReadoutBook* book );
    Tvoid SetCrate( TCrate* crate );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TEventAction,0)
#endif

};

inline TRunManager* TEventAction::GetRunManager() const
{
  return theRunManager;
}

inline TEventManager* TEventAction::GetEventManager() const
{
  return theEventManager;
}

inline TReadoutBook* TEventAction::GetReadoutBook() const
{
  return theReadoutBook;
}

inline TCrate* TEventAction::GetCrate() const
{
  return theCrate;
}

inline Tvoid TEventAction::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

inline Tvoid TEventAction::SetEventManager( TEventManager* manager )
{
  theEventManager = manager;
  return;
}

inline Tvoid TEventAction::SetReadoutBook( TReadoutBook* book )
{
  theReadoutBook = book;
  return;
}

inline Tvoid TEventAction::SetCrate( TCrate* crate )
{
  theCrate = crate;
  return;
}

#endif
