// =====================================================================
/*!
//
//  \file TStringStreamBuffer.hh
//  \brief This file contains the TStringStreamBuffer class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TStringStreamBuffer.hh,v 1.1 2004/06/24 15:17:51 goiwai Exp $
//  $Name: CLDAQ-1-14-01 $
//  $Log: TStringStreamBuffer.hh,v $
//  Revision 1.1  2004/06/24 15:17:51  goiwai
//  std::coutơTOutputStreamΥ֥TcoutȤȤˤͳϡ򤫤֤Ƥꤿä顣
//  SystemActionCatchǤ롣
//
//
*/
// =====================================================================
#ifndef CLDAQ__TEXCEPTION_HH
#define CLDAQ__TEXCEPTION_HH

#include "Ttypes.h"

class TSystemAction;

/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TStringStreamBuffer
// \brief This is the TStringStreamBuffer class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TStringStreamBuffer class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/

class TStringStreamBuffer
  : public std::streambuf
{

  protected:
    TSystemAction* theSystemAction;
    Tchar* theString;
    Tint theLength;
    Tint theIndex;
    Tint theLogLevel;

  public:
    TStringStreamBuffer( Tint len = 0x1000 );
    virtual ~TStringStreamBuffer();

  public:
    virtual Tint sync();
    virtual Tint overflow( Tint c = EOF);
    virtual Tvoid ReceiveString();

  public:
    TSystemAction* GetSystemAction() const;
    Tchar* GetString() const;
    Tint GetLength() const;
    Tint GetIndex() const;
    Tint GetLogLevel() const;
    Tvoid SetSystemAction( TSystemAction* action );
    Tvoid SetLogLevel( Tint level );

  protected:
    TStringStreamBuffer( const TStringStreamBuffer& right );
    virtual TStringStreamBuffer& operator=( const TStringStreamBuffer& right );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TStringStreamBuffer,0)
#endif

};

inline TSystemAction* TStringStreamBuffer::GetSystemAction() const
{
  return theSystemAction;
}

inline Tchar* TStringStreamBuffer::GetString() const
{
  return theString;
}

inline Tint TStringStreamBuffer::GetLength() const
{
  return theLength;
}

inline Tint TStringStreamBuffer::GetIndex() const
{
  return theIndex;
}

inline Tint TStringStreamBuffer::GetLogLevel() const
{
  return theLogLevel;
}

inline Tvoid TStringStreamBuffer::SetSystemAction( TSystemAction* action )
{
  theSystemAction = action;
  return;
}

inline Tvoid TStringStreamBuffer::SetLogLevel( Tint level )
{
  theLogLevel = level;
}

#endif
