// =====================================================================
//  $Id: sw00adcview.cc,v 1.4 2003/10/12 13:08:47 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: sw00adcview.cc,v $
//  Revision 1.4  2003/10/12 13:08:47  goiwai
//  饤Τۤ TInputObjectFileOnline Ȥ褦ˤޤ.
//
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFileOnline.hh"
#include "Trootinit.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return -1;
  }

  TApplication* theApplication = rootinit();

  Tstring filename = argv[ 1 ];
  TInputObjectFileOnline ifile( filename );
  TDataRecord record;

  TCanvas* canvas = new TCanvas( "adc", "ADC VIEWER", 800, 800 );
  canvas -> Divide( 4, 4, 0.0, 0.0 );

  TH1D** adchist = new TH1D*[ 16 ];
  for ( Tint i = 0; i < 16; i ++ ) {

    Tstring name = "adc" + itostr( i, 2 );
    Tstring title = "ADC #" + itostr( i, 2 );
    adchist[ i ] = new TH1D( name.c_str(), title.c_str(), 50, 0, 4095 );
    canvas -> cd( i + 1 );
    adchist[ i ] -> Draw();
  }

  Tstring idset[ 2 ] = { "Event Data", "ADC" };

  while ( ifile.Read( record ) ) {

    Tstring recid = record.GetID();

    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "EVENT" ) {

      TDataSegment segment;
      record.FindDataSegment( idset, segment );

      for ( Tint i = 0; i < 16; i ++ ) {
	TDataElement element = segment[ i ];
	Tint count = *( element.GetIntData() );
	adchist[ i ] -> Fill( (Tdouble)count );
        canvas -> GetPad( i + 1 ) -> Modified();
        canvas -> GetPad( i + 1 ) -> Update();
      }

      canvas -> Modified();
      canvas -> Update();

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApplication -> Run();

  return 0;
}
