// =====================================================================
//  $Id: Sw01SystemAction.cc,v 1.5 2004/06/28 07:16:46 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: Sw01SystemAction.cc,v $
//  Revision 1.5  2004/06/28 07:16:46  goiwai
//  *** empty log message ***
//
//  Revision 1.4  2004/06/28 04:02:58  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2004/06/24 15:19:43  goiwai
//  SystemAction::Catch()νϤʤ󤫣Ԥˤ狼Ƥ뤬Ȥꤢ֡
//
//  Revision 1.2  2004/03/04 15:11:55  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.1  2004/03/01 09:48:30  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TSystemLogging.hh"
#include "Sw01SystemAction.hh"
#include "Sw01EventDisplay.hh"

Sw01SystemAction::Sw01SystemAction()
  : TSystemAction(), theEventDisplay( 0 )
{;}

Sw01SystemAction::~Sw01SystemAction()
{;}

Tvoid Sw01SystemAction::Boot( TRunManager* manager )
{
  theEventDisplay = new Sw01EventDisplay( manager );
  Tclog << "$Id: Sw01SystemAction.cc,v 1.5 2004/06/28 07:16:46 goiwai Exp $" << Tendl;
  Tclog << "Software DAQ demonstration start." << Tendl;
  return;
}

Tvoid Sw01SystemAction::Shutdown( TRunManager* manager )
{
  delete theEventDisplay;
  return;
}

Tvoid Sw01SystemAction::CatchStandardOut( Tstring message )
{
  std::cout << message << std::flush;
  return;
}

Tvoid Sw01SystemAction::CatchStandardError( Tstring message )
{
  std::cerr << message << std::flush;
  return;
}

Tvoid Sw01SystemAction::CatchLog( Tstring message, Tint level )
{
  Tinfo << message << Tflush;
  return;
}
