// =====================================================================
//  $Id: TPrintEnvironmentVariableCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: TPrintEnvironmentVariableCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TPrintEnvironmentVariableCommand.hh"
#include "TEnvironmentVariableTable.hh"

static const Tstring _name = "printenv";
static const Tstring _desc = "print all or part of environment.\nexample> printenv ITEM\nexample> printenv";

TPrintEnvironmentVariableCommand::TPrintEnvironmentVariableCommand( TRunManager* manager, TEnvironmentVariableTable* table )
  : TCommand( manager, _name, _desc ), TEnvironmentVariableCommand( table )
{;}

TPrintEnvironmentVariableCommand::~TPrintEnvironmentVariableCommand()
{;}

Tvoid TPrintEnvironmentVariableCommand::Execute( const TstringList& arguments )
{
  static const Tstring head = "TPrintEnvironmentVariableCommand::Execute: ";

  if ( arguments.empty() ) {
    Tcout << *theEnvironmentVariableTable << Tendl;
  } else if ( arguments.size() == 1 ) {
    Tcout << theEnvironmentVariableTable -> GetEnvironmentValue( arguments[ 0 ] ) << Tendl;
  } else {
    ShowCommandDetail();
  }
  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TPrintEnvironmentVariableCommand)
#endif
