// =====================================================================
/*!
//
//  \file TVmeDaughterBoardMemoryModule.hh
//  \brief This file contains the TVmeDaughterBoardMemoryModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TVmeDaughterBoardMemoryModule.hh,v 1.7 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: TVmeDaughterBoardMemoryModule.hh,v $
//  Revision 1.7  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.6  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.5  2003/11/04 20:25:20  goiwai
//  ȤäƤޤ
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:12  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TVMEDAUGHTERBOARDMEMORYMODULE_HH
#define CLDAQ__TVMEDAUGHTERBOARDMEMORYMODULE_HH

#include "Tglobals.h"
#include "TVmeModule.hh"

class TDataElement;
class TVmeMpx201aModule;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TVmeDaughterBoardMemoryModule
// \brief This is the TVmeDaughterBoardMemoryModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TVmeDaughterBoardMemoryModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TVmeDaughterBoardMemoryModule
  : public TVmeModule
{

  public:
    enum { tDataUnderflow = SHRT_MIN, tDataOverflow = SHRT_MAX };

  private:
    Tint theNumberOfSampling;

  public:
    TVmeDaughterBoardMemoryModule( Toff_t offset, Tint mapsize, Tint nblock, Tint nch = 1 );
    TVmeDaughterBoardMemoryModule( const TVmeMpx201aModule* mpx201a, Tint nch = 1 );
    TVmeDaughterBoardMemoryModule( const TVmeDaughterBoardMemoryModule& right );
    ~TVmeDaughterBoardMemoryModule();

  public:
    const TVmeDaughterBoardMemoryModule& operator=( const TVmeDaughterBoardMemoryModule& right );
    Tbool operator==( const TVmeDaughterBoardMemoryModule& right ) const;
    Tbool operator!=( const TVmeDaughterBoardMemoryModule& right ) const;

  public:
    Tint GetNumberOfSampling() const;
    Tvoid SetNumberOfSampling( Tint nsamples );

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  private:
    Tshort modifyData( Tlong databuf ) const;

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TVmeDaughterBoardMemoryModule,0)
#endif

};

inline Tint TVmeDaughterBoardMemoryModule::GetNumberOfSampling() const
{
  return theNumberOfSampling;
}

inline Tvoid TVmeDaughterBoardMemoryModule::SetNumberOfSampling( Tint nsamples )
{
  theNumberOfSampling = nsamples;
  return;
}

#endif
