// =====================================================================
//  $Id: Rs00RunAction.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRun.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TOutputObjectFile.hh"
#include "TReadoutBook.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs00RunAction.hh"

Rs00RunAction::Rs00RunAction()
  : theOutputFile( 0 )
{;}

Rs00RunAction::~Rs00RunAction()
{;}

Tvoid Rs00RunAction::BeginOfRunAction( TRun& aRun )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring drecdir = envtable.GetEnvironmentValue( "RS00_RECORD_DIR" );

  Tstring drecpath = drecdir + "run" + aRun.GetStringRunID() + ".drec";
  theCrate -> Initialize();
  theOutputFile = new TOutputObjectFile( drecpath );
  return;
}

Tvoid Rs00RunAction::EndOfRunAction( TRun& aRun )
{
  delete theOutputFile;
  theOutputFile = 0;
  return;
}
