// =====================================================================
//  $Id: Rs01RunAction.hh,v 1.1 2003/07/06 03:21:34 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __RS01RUNACTION_HH
#define __RS01RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class Rs01RunSummary;

class Rs01RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    Rs01RunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    Rs01RunAction();
    ~Rs01RunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    Rs01RunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile );

};

inline TOutputObjectFile* Rs01RunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline Rs01RunSummary* Rs01RunAction::GetRunSummary() const
{
  return( theRunSummary );
}

inline TOutputHtmlFileStream& Rs01RunAction::GetOutputHtml()
{
  return( theOutputHtml );
}

#endif
