// =====================================================================
//  $Id: St00Map.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __ST0001MAP_HH
#define __ST0001MAP_HH

#include "Tglobals.h"
#include "TDataMultiplicity.hh"
#include "TEnvironmentVariableTable.hh"

enum Tpixel_t { tEffective, tHoc, tIgnore, tEndOfHoc };

class St00Map
{

  protected:
    TEnvironmentVariableTable theEnvironmentVariableTable;
    Tint theNumberOfHorizontalPixels;
    Tint theNumberOfVerticalPixels;
    Tint theRateOfVerticalShift;
    Tint theNumberOfHorizontalOverClockPixels;
    Tstring theInputFileName;
    Tdouble theHOCbuffer;
    TDataMultiplicity theMap;

  protected:
    St00Map( const Tstring& filename );
    virtual ~St00Map();

  public:
    Tint GetNumberOfHorizontalPixels() const;
    Tint GetNumberOfVerticalPixels() const;
    Tint GetRateOfVerticalShift() const;
    const Tstring& GetInputFileName() const;
    const TDataMultiplicity& GetMap() const;
    TDataMultiplicity& GetMap();
    const TEnvironmentVariableTable& GetEnvironmentVariableTable() const;
    TEnvironmentVariableTable& GetEnvironmentVariableTable();

  public:
    Tpixel_t IsThisPixel( Tint dataid ) const;
    virtual Tvoid FillMap( Tshort* data, Tint ndata );

};

inline Tint St00Map::GetNumberOfHorizontalPixels() const
{
  return( theNumberOfHorizontalPixels );
}

inline Tint St00Map::GetNumberOfVerticalPixels() const
{
  return( theNumberOfVerticalPixels );
}

inline Tint St00Map::GetRateOfVerticalShift() const
{
  return( theRateOfVerticalShift );
}

inline const Tstring& St00Map::GetInputFileName() const
{
  return( theInputFileName );
}

inline const TDataMultiplicity& St00Map::GetMap() const
{
  return( theMap );
}

inline TDataMultiplicity& St00Map::GetMap()
{
  return( theMap );
}
inline const TEnvironmentVariableTable& St00Map::GetEnvironmentVariableTable() const
{
  return( theEnvironmentVariableTable );
}
inline TEnvironmentVariableTable& St00Map::GetEnvironmentVariableTable()
{
  return( theEnvironmentVariableTable );
}

#endif
