// =====================================================================
//  $Id: St00OfflineDarkAverageMap.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __ST0001OFFLINEDARKAVERAGEMAP_HH
#define __ST0001OFFLINEDARKAVERAGEMAP_HH

#include "Tglobals.h"
#include "St00Map.hh"

class St00OfflineDarkAverageMap
  : public St00Map
{

  private:
    TDataMultiplicity theCounterMap;
    Tint theNumberOfFrames;

  public:
    St00OfflineDarkAverageMap( const Tstring& filename );
    ~St00OfflineDarkAverageMap();

  public:
    Tvoid FillMap( Tshort* data, Tint ndata );
    const TDataMultiplicity& GetCounterMap() const;
    TDataMultiplicity& GetCounterMap();
    Tint GetNumberOfFrames() const;

};

inline const TDataMultiplicity& St00OfflineDarkAverageMap::GetCounterMap() const
{
  return( theCounterMap );
}

inline TDataMultiplicity& St00OfflineDarkAverageMap::GetCounterMap()
{
  return( theCounterMap );
}

inline Tint St00OfflineDarkAverageMap::GetNumberOfFrames() const
{
  return( theNumberOfFrames );
}

#endif
