// =====================================================================
//  $Id: OFFsubplot.cc,v 1.1 2003/06/30 03:46:06 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

#include "St01DataRecordConversion.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = rootinit();
  TCanvas cv( "CVfadc", "Pentland MPX201A" );
  TH1D mpx201a( "mpx201a", "subtracted H.O.C", 500, -1000.0, 4096.0 );
  //mpx201a.SetFillColor( 45 );


  St01DataRecordConversion conversion;
  TDataRecord r;
  Tstring ifname = argv[ 1 ];
  TInputObjectFile ifile( ifname );
  while ( ( ifile >> r ) != 0 ) {
    TDataMultiplicity& map = conversion.Convert( r );
    if ( conversion.IsSuccess() ) {
      for ( Tint row = 0; row < map.num_row(); row ++ ) {
	for ( Tint col = 0; col < map.num_col(); col ++ ) {
	  mpx201a.Fill( map[ row ][ col ] );
	} 
      }
    }
  }

  cv.cd();
  mpx201a.Draw();
  theApplication -> Run();

  return( 0 );
}
