// =====================================================================
//  $Id: St02DataRecordConversion.cc,v 1.1 2003/07/11 05:34:14 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "St02DataRecordConversion.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"

St02DataRecordConversion::St02DataRecordConversion()
  : St02Map( "" ), theConversionSuccess( Tfalse )
{;}

St02DataRecordConversion::~St02DataRecordConversion()
{;}

TDataMultiplicity& St02DataRecordConversion::Convert( const TDataRecord& record )
{
  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TDataElement e;
  if ( record.FindDataElement( fadcidset, e ) ) {
    Tshort* data = e.GetShortData();
    Tint ndata = e.GetNumberOfPrimitives();
    FillMap( data, ndata );
    theConversionSuccess = Ttrue;
  } else {
    theConversionSuccess = Tfalse;
  }

  return( theMap );
}
