// =====================================================================
//  $Id: TAnalysisStartCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TAnalysisStartCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring _name = "/analysis/start";
static const Tstring _desc = "start an analysis.";

TAnalysisStartCommand::TAnalysisStartCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, _name, _desc ), TAnalysisCommand( anaman )
{;}

TAnalysisStartCommand::~TAnalysisStartCommand()
{;}

Tvoid TAnalysisStartCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> StartAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> StartAnalysis( arguments[ i ] );
  }
  return;
}
