// =====================================================================
//  $Id: THelpCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "THelpCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "help";
static const Tstring _desc = "print a detail of command given as argument.";

THelpCommand::THelpCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

THelpCommand::~THelpCommand()
{;}

Tvoid THelpCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();

  if ( ui ) {
    Tstring path = ui -> ModifyPath( arguments[ 0 ] );
    TCommand* com = ui -> FindCommand( path );
    if ( com ) {
      const TCommandTable& table = ui -> GetCommandTable();
      Tcout << table.GetCommandSpecified( path ) << Tendl;
      Tcout << com -> GetGuidance() << Tendl;
    } else {
      ui -> NotFoundCommand( arguments[ 0 ] );
    }
  }

  return;
}
