// =====================================================================
//  $Id: TShowRunInformationModuleCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TShowRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"

static const Tstring _name = "/run/showinfo";
static const Tstring _desc = "show run information in the table.";

TShowRunInformationModuleCommand::TShowRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TShowRunInformationModuleCommand::~TShowRunInformationModuleCommand()
{;}

Tvoid TShowRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  Tstring head = "TShowRunInformationModuleCommand::Execute: ";
  if ( theRunInformationModule == 0 ) {
    return;
  }
  Tcout << theRunInformationModule -> GetRunInformationTable() << Tendl;
  return;
}
