// =====================================================================
//  $Id: TSourceCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TSourceCommand.hh"
#include "TUserInterface.hh"
#include "TRunManager.hh"

static const Tstring _name = "source";
static const Tstring _desc = "read and set environment from filename.";

TSourceCommand::TSourceCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSourceCommand::~TSourceCommand()
{;}

Tvoid TSourceCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() == 1 ) {
    TUserInterface* ui = theRunManager -> GetUserInterface();
    ui -> ExecuteCommand( "setenv", arguments );
  } else {
    ShowCommandDetail();
  }
  return;
}
