// =====================================================================
//  $Id: TCrate.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TCRATE_HH
#define __TCRATE_HH

#include "Tglobals.h"
#include "TModuleTable.hh"

class TModule;

class TCrate
{

  private:
    TModuleTable theModuleTable;

  public:
    TCrate();
    ~TCrate();

  public:
    Tint InstallModule( TModule* module, const Tstring& id, const TstringList& group );
    Tint InstallModule( TModule* module, const Tstring& id, const Tstring& group = "" );
    Tint RemoveModule( Tint index );
    Tint RemoveModule( const Tstring& id );
    Tint RemoveModule( const TstringList& groups );
    Tvoid ClearCrate();
    TModule* FindModule( const Tstring& id );
    TModule* GetModule( Tint index );
    TModule* GetModule( const Tstring& id );

  public:
    const TModuleTable& GetModuleTable() const;
    TModuleTable& GetModuleTable();
    Tvoid SetModuleTable( const TModuleTable& table );

  public:
    Tvoid Clear();
    Tvoid Clear( const TstringList& groups );
    Tvoid Clear( const Tstring& group );
    Tvoid Update();
    Tvoid Update( const TstringList& groups );
    Tvoid Update( const Tstring& group );
    Tvoid Initialize();
    Tvoid Initialize( const TstringList& groups );
    Tvoid Initialize( const Tstring& group );
    Tvoid ClearAllModules();
    Tvoid UpdateAllModules();
    Tvoid InitializeAllModules();
    Tvoid ClearModule( const Tstring& id );
    Tvoid UpdateModule( const Tstring& id );
    Tvoid InitializeModule( const Tstring& id );

};

inline const TModuleTable& TCrate::GetModuleTable() const
{
  return( theModuleTable );
}

inline TModuleTable& TCrate::GetModuleTable()
{
  return( theModuleTable );
}

inline Tvoid TCrate::SetModuleTable( const TModuleTable& table )
{
  theModuleTable = table;
  return;
}

#endif
