// =====================================================================
//  $Id: TModuleSpecified.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TModuleSpecified.hh"

TModuleSpecified::TModuleSpecified()
  : theModuleID(), theGroupIDs(), theModule( 0 )
{
  theGroupIDs.clear();
}

TModuleSpecified::TModuleSpecified( const Tstring& id, const TstringList& groups, TModule* module )
  : theModuleID( id ), theGroupIDs( groups ), theModule( module )
{;}

TModuleSpecified::TModuleSpecified( const TModuleSpecified& right )
  : theModuleID( right.theModuleID ), theGroupIDs( right.theGroupIDs ),
    theModule( right.theModule )
{;}

TModuleSpecified::~TModuleSpecified()
{;}

const TModuleSpecified& TModuleSpecified::operator=( const TModuleSpecified& right )
{
  theModuleID = right.theModuleID;
  theGroupIDs = right.theGroupIDs;
  theModule = right.theModule;
  return( *this );
}

Tbool TModuleSpecified::operator==( const TModuleSpecified& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theModuleID == right.theModuleID );
  retval &= ( theGroupIDs == right.theGroupIDs );
  retval &= ( theModule == right.theModule );
  return( retval );
}

Tbool TModuleSpecified::operator!=( const TModuleSpecified& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theModuleID != right.theModuleID );
  retval |= ( theGroupIDs != right.theGroupIDs );
  retval |= ( theModule != right.theModule );
  return( retval );
}

Tbool TModuleSpecified::IsSameGroup( const TstringList& groups )
{
  for ( Tsize_t i = 0; i < theGroupIDs.size(); i ++ ) {
    for ( Tsize_t j = 0; j < groups.size(); j ++ ) {
      if ( theGroupIDs[ i ] == groups[ j ] ) {
	return( Ttrue );
      }
    }
  }
  return( Tfalse );
}

Tbool TModuleSpecified::IsSameGroup( const TModuleSpecified& spec )
{
  return( IsSameGroup( spec.GetGroupIDs() ) );
}

Tbool TModuleSpecified::IsSameGroup( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  return( IsSameGroup( groups ) );
}

Tostream& operator<<( Tostream& tos, const TModuleSpecified& right )
{
  tos << "ID: " << right.theModuleID << ", ";
  tos << "GID(s): ";
  Tsize_t ngroups = right.theGroupIDs.size();
  for ( Tsize_t i = 0; i < ngroups; i ++ ) {
    tos << right.theGroupIDs[ i ] << ", ";
  }
  tos << right.theModule << Tflush;
  return( tos );
}
