// =====================================================================
//  $Id: TObjectSocket.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TObjectSocket.hh"

TObjectSocket::TObjectSocket( Tint portnumber )
  : theServerDescriptor( -1 ), thePortNumber( portnumber )
{;}

TObjectSocket::~TObjectSocket()
{;}

Tint TObjectSocket::OpenServer()
{
  theServerDescriptor = socket( PF_INET, SOCK_STREAM, 0 );
  if ( theServerDescriptor == -1 )
    perror( "TObjectSocket::OpenServer" );
  return( theServerDescriptor );
}

Tint TObjectSocket::CloseServer()
{
  if ( shutdown( theServerDescriptor, 2 ) == -1 ) {
    perror( "TObjectSocket::CloseServer" );
    return( -1 );
  }

  if ( close( theServerDescriptor ) == -1 ) {
    perror( "TObjectSocket::CloseServer" );
    return( -1 );
  }
  theServerDescriptor = -1;
  return( 0 );
}
