// =====================================================================
//  $Id: TReadoutSection.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TREADOUTSECTION_HH
#define __TREADOUTSECTION_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"
#include "TReadoutSegmentList.hh"

class TDataSection;

class TReadoutSection
  : public TReadoutIdentification, public TReadoutSegmentList
{

  public:
    TReadoutSection( const Tstring& id = TunknownID );
    TReadoutSection( const TReadoutSection& right );
    ~TReadoutSection();

  public:
    const TReadoutSection& operator=( const TReadoutSection& right );
    Tbool operator==( const TReadoutSection& right ) const;
    Tbool operator!=( const TReadoutSection& right ) const;

  public:
    TDataSection Read();

};

#endif
