// =====================================================================
//  $Id: Rs01RunSummary.cc,v 1.1 2003/07/06 03:21:34 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "Rs01RunSummary.hh"

Rs01RunSummary::Rs01RunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfEvents( 0 ), 
    theRunInformationTable(),
    theRunBeginTime(),
    theRunEndTime()
{;}

Rs01RunSummary::~Rs01RunSummary()
{;}

Tvoid Rs01RunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfEvents = 0; 
  theRunInformationTable.Clear();
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable Rs01RunSummary::GenerateRunSummaryTable() const
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "RUN ID", itostr( theRunID, 0 ) ) );
  infolist.push_back( TRunInformation( "RECORD PATH", theRecordName ) );
  infolist.push_back( TRunInformation( "RECORD SIZE", itostr( theRecordSize, 0 ) ) );
  infolist.push_back( TRunInformation( "RUN BEGIN", theRunBeginTime ) );
  infolist.push_back( TRunInformation( "RUN END", theRunEndTime ) );
  infolist.push_back( TRunInformation( "EVENTS", itostr( theNumberOfEvents, 0 ) ) );

  return( theRunInformationTable + infolist );
}
