// =====================================================================
//  $Id: Sw00EventAction.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TEvent.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TEnvironmentVariableTable.hh"

#include "Sw00EventAction.hh"
#include "Sw00RunAction.hh"

Sw00EventAction::Sw00EventAction()
{;}

Sw00EventAction::~Sw00EventAction()
{;}

TReadoutList* Sw00EventAction::WaitEvent()
{
  TSoftwareInterruptRegisterModule* ir =
    (TSoftwareInterruptRegisterModule*)( theCrate -> GetModule( "Interrupt Register" ) );
  Tbool trigger = Tfalse;
  do {
    if ( ir -> ReadInterruptRegister() == 1 ) {
      trigger = Ttrue;
      break;
    }
  } while ( trigger == Tfalse );

  return( theReadoutBook -> GetReadoutList( "EVENT" ) );
}

Tvoid Sw00EventAction::BeginOfEventAction( TEvent& anEvent )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint mask = envtable.GetIntegerValue( "SW00_INTERRUPT_MASK" );

  TSoftwareInterruptRegisterModule* ir =
    (TSoftwareInterruptRegisterModule*)( theCrate -> GetModule( "Interrupt Register" ) );
  ir -> SetInterruptMaskRegister( mask );

  return;
}

Tvoid Sw00EventAction::EndOfEventAction( TEvent& anEvent )
{
  Sw00RunAction* action =
    (Sw00RunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  *ofile << anEvent.GetDataRecord();

  theCrate -> GetModule( "Event ID" ) -> Update();
  theCrate -> GetModule( "Flash ADC" ) -> Update();
  theCrate -> GetModule( "ADC" ) -> Update();
  theCrate -> GetModule( "Geant4" ) -> Update();

  theCrate -> GetModule( "Interrupt Register" ) -> Clear();

  return;
}
