// =====================================================================
//  $Id: Sw00FlashAdcViewCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Sw00FlashAdcViewCommand.hh"
#include "Sw00RunAction.hh"

static const Tstring _name = "/local/sw00fadcview";
static const Tstring _desc = "view 2D plot(Flash ADC)";

Sw00FlashAdcViewCommand::Sw00FlashAdcViewCommand()
  : TCommand( _name, _desc )
{;}

Sw00FlashAdcViewCommand::~Sw00FlashAdcViewCommand()
{;}

Tvoid Sw00FlashAdcViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "SW00_BIN_DIR" );
  Tstring comname = bindir + Tslash + "sw00fadcview";

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Sw00RunAction* action = (Sw00RunAction*)( theRunManager -> GetRunAction() );
  Tstring filename = action -> GetOutputFile() -> GetFileName();
  Tstring com = "/system/shell";
  TstringList args;
  args.push_back( comname );
  args.push_back( filename );
  args.push_back( "&" );

  ui -> ExecuteCommand( com, args );

  return;
}
