// =====================================================================
//  $Id: sw00.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRunManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "Sw00RunAction.hh"
#include "Sw00EventAction.hh"
#include "Sw00CrateDefinition.hh"
#include "Sw00ReadoutBookDefinition.hh"
#include "Sw00AdcViewCommand.hh"
#include "Sw00FlashAdcViewCommand.hh"
#include "Sw00Geant4ViewCommand.hh"

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );

  manager -> GetEnvironmentVariableTable().SetEnvironment( "sw00setup" );
  manager -> SetRunAction( new Sw00RunAction() );
  manager -> SetEventAction( new Sw00EventAction() );
  manager -> SetCrateDefinition( new Sw00CrateDefinition() );
  manager -> SetReadoutBookDefinition( new Sw00ReadoutBookDefinition() );

  manager -> SetUserCommand( new Sw00AdcViewCommand() );
  manager -> SetUserCommand( new Sw00FlashAdcViewCommand() );
  manager -> SetUserCommand( new Sw00Geant4ViewCommand() );


  manager -> SessionStart();

  delete manager;
  return( 0 );
}
