// =====================================================================
//  $Id: St00BadChannelMap.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __ST0001BADCHANNELMAP_HH
#define __ST0001BADCHANNELMAP_HH

#include "Tglobals.h"
#include "St00Map.hh"
#include "St00OfflineRmsMap.hh"

class St00BadChannelMap
  : public St00Map
{

  private:
    St00OfflineRmsMap theOfflineRmsMap;

  public:
    St00BadChannelMap( const Tstring& filename );
    ~St00BadChannelMap();

  public:
    const St00OfflineRmsMap& GetOfflineRmsMap() const;

  public:
    Tbool IsBadChannel( Tint row, Tint col ) const;
    Tbool IsGoodChannel( Tint row, Tint col ) const;
    Tvoid SetBadChannel( Tint row, Tint col );
    Tvoid SetGoodChannel( Tint row, Tint col );
    Tint GetNumberOfBadChannels() const;
    Tint GetNumberOfGoodChannels() const;

};

inline const St00OfflineRmsMap& St00BadChannelMap::GetOfflineRmsMap() const
{
  return( theOfflineRmsMap );
}

#endif
