// =====================================================================
//  $Id: st00.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "St00RunAction.hh"
#include "St00EventAction.hh"
#include "St00CrateDefinition.hh"
#include "St00ReadoutBookDefinition.hh"
#include "St00PureEventViewCommand.hh"
#include "St00MinusHocEventViewCommand.hh"
#include "St00DarkRmsViewCommand.hh"

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );
  manager -> GetEventManager() -> SetStackSize( 4 );
  manager -> GetEnvironmentVariableTable().SetEnvironment( "setenvrc" );
  manager -> SetRunAction( new St00RunAction() );
  manager -> SetEventAction( new St00EventAction() );
  manager -> SetCrateDefinition( new St00CrateDefinition() );
  manager -> SetReadoutBookDefinition( new St00ReadoutBookDefinition() );

  manager -> SetUserCommand( new St00PureEventViewCommand() );
  manager -> SetUserCommand( new St00MinusHocEventViewCommand() );
  manager -> SetUserCommand( new St00DarkRmsViewCommand() );

  manager -> SessionStart();

  delete manager;

  return( 0 );
}
