// =====================================================================
//  $Id: TAnalysisResumeCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TAnalysisResumeCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring _name = "/analysis/resume";
static const Tstring _desc = "resume an analysis.";

TAnalysisResumeCommand::TAnalysisResumeCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, _name, _desc ), TAnalysisCommand( anaman )
{;}

TAnalysisResumeCommand::~TAnalysisResumeCommand()
{;}

Tvoid TAnalysisResumeCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> ResumeAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> ResumeAnalysis( arguments[ i ] );
  }
  return;
}
