// =====================================================================
//  $Id: TDateCommand.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TDATECOMMAND_HH
#define __TDATECOMMAND_HH

#include "Tglobals.h"
#include "TCommand.hh"
#include "TSystemClock.hh"

class TRunManager;
class TSystemClock;

class TDateCommand
  : public TCommand
{

  private:
    TSystemClock theSystemClock;

  public:
    TDateCommand( TRunManager* manager );
    ~TDateCommand();

  public:
    Tvoid Execute( const TstringList& arguments );

  public:
    const TSystemClock& GetSystemClock() const;
    Tvoid SetSystemClock( const TSystemClock& clock );

};

inline const TSystemClock& TDateCommand::GetSystemClock() const
{
  return( theSystemClock );
}

inline Tvoid TDateCommand::SetSystemClock( const TSystemClock& clock )
{
  theSystemClock = clock;
  return;
}

#endif
