// =====================================================================
//  $Id: TVmeModule.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TVMEMODULE_HH
#define __TVMEMODULE_HH

#include "Tglobals.h"
#include "TModule.hh"

class TVmeModule
  : public TModule
{

  protected:
    Tsize_t theMappedSize;
    TvmeTransfer_t theTransferMode;
    Tint theFileDescriptor;
    Tcaddr_t theBaseAddress;
    Toff_t theOffsetAddress;

  public:
    TVmeModule( Tint nch, Toff_t offset, Tint mapsize, TvmeTransfer_t mode );
    TVmeModule( const TVmeModule& right );

  protected:
    virtual ~TVmeModule();

  public:
    virtual const TVmeModule& operator=( const TVmeModule& right );
    virtual Tbool operator==( const TVmeModule& right ) const;
    virtual Tbool operator!=( const TVmeModule& right ) const;

  public:
    Tsize_t GetMappedSize() const;
    TvmeTransfer_t GetTransferMode() const;
    Tint GetFileDescriptor() const;
    Tcaddr_t GetBaseAddress() const;
    Toff_t GetOffsetAddress() const;
    Tvoid SetMappedSize( Tsize_t mapsize );
    Tvoid SetTransferMode( TvmeTransfer_t mode );
    Tvoid SetFileDescriptor( Tint fd );
    Tvoid SetBaseAddress( Tcaddr_t address );
    Tvoid SetOffsetAddress( Toff_t offset );

  protected:
    Tvoid showBit( TUshort data, const Tstring comment = "" ) const;
    Tvoid setBit( TUshort* ptr, Tint nbit, Tbit bit );
    Tbit getBit( TUshort* ptr, Tint nbit ) const;

};

inline Tsize_t TVmeModule::GetMappedSize() const
{
  return( theMappedSize );
}

inline TvmeTransfer_t TVmeModule::GetTransferMode() const
{
  return( theTransferMode );
}

inline Tint TVmeModule::GetFileDescriptor() const
{
  return( theFileDescriptor );
}

inline Tcaddr_t TVmeModule::GetBaseAddress() const
{
  return( theBaseAddress );
}

inline Toff_t TVmeModule::GetOffsetAddress() const
{
  return( theOffsetAddress );
}

inline Tvoid TVmeModule::SetMappedSize( Tsize_t mapsize )
{
  theMappedSize = mapsize;
  return;
}

inline Tvoid TVmeModule::SetTransferMode( TvmeTransfer_t mode )
{
  theTransferMode = mode;
  return;
}

inline Tvoid TVmeModule::SetFileDescriptor( Tint fd )
{
  theFileDescriptor = fd;
  return;
}

inline Tvoid TVmeModule::SetBaseAddress( Tcaddr_t address )
{
  theBaseAddress = address;
  return;
}

inline Tvoid TVmeModule::SetOffsetAddress( Toff_t offset )
{
  theOffsetAddress = offset;
  return;
}

#endif
