// =====================================================================
//  $Id: TObjectSharedMemory.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TObjectSharedMemory.hh"

TObjectSharedMemory* TObjectSharedMemory::theObjectSharedMemory = 0;

TObjectSharedMemory::TObjectSharedMemory( Tint memsize, Tint maxevt )
  : theSharedMemoryID( -1 ), theMemorySize( memsize ),
    theMaxEvent( maxevt ), theCurrentPositionOfMemorySpace( 0 ),
    theReadable( 0 ), theBaseAddress( 0 ), theAddress( 0 )
{
  Tstring head = "TObjectSharedMemory::TObjectSharedMemory: ";

  theSharedMemoryID =
    shmget( ftok( getenv( "HOME" ), Tkey ), theMemorySize, 0666 | IPC_CREAT );
  if ( theSharedMemoryID == -1 ) {
    Tcerr << head << "failed getting shared memory ID." << Tendl;
    exit( -errno );
  }
  Tvoid* voidbuf = Attach();
  if ( voidbuf == (Tvoid*)-1 ) {
    Tcerr << head << "failed attach." << Tendl;
    exit( -errno );
  }

  theReadable = (Tbool*)voidbuf;
  SetReadable( Tfalse );

  ( (Tbool*)voidbuf ) ++;
  theBaseAddress = voidbuf;
  theAddress = theBaseAddress;
  theObjectSharedMemory = this;
}

TObjectSharedMemory::~TObjectSharedMemory()
// When output object destruct, invoked Dettach(), Remove() functions.
{
  theObjectSharedMemory = 0;
}
