// =====================================================================
//  $Id: St01RunSummary.cc,v 1.2 2003/07/30 16:16:11 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: St01RunSummary.cc,v $
//  Revision 1.2  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "St01RunSummary.hh"

St01RunSummary::St01RunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfEvents( 0 ), 
    theRunInformationTable(),
    theRunBeginTime(),
    theRunEndTime(),
    theTempAve( DBL_MAX ),
    theTempMax( DBL_MAX ),
    theTempMin( DBL_MAX ),
    theDarkAve( DBL_MAX ),
    theDarkMax( DBL_MAX ),
    theDarkMin( DBL_MAX ),
    theSignalAve( DBL_MAX ),
    theSignalMax( DBL_MAX ),
    theSignalMin( DBL_MAX ),
    theHocAve( DBL_MAX )
{;}

St01RunSummary::~St01RunSummary()
{;}

Tvoid St01RunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfEvents = 0; 
  theRunInformationTable.Clear();
  theRunBeginTime.erase();
  theRunEndTime.erase();

  theTempAve = DBL_MAX;
  theTempMax = DBL_MAX;
  theTempMin = DBL_MAX;
  theDarkAve = DBL_MAX;
  theDarkMax = DBL_MAX;
  theDarkMin = DBL_MAX;
  theSignalAve = DBL_MAX;
  theSignalMax = DBL_MAX;
  theSignalMin = DBL_MAX;
  theHocAve = DBL_MAX;

  return;
}

TRunInformationTable St01RunSummary::GenerateRunSummaryTable() const
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "RUN ID", itostr( theRunID ) ) );
  infolist.push_back( TRunInformation( "RECORD PATH", theRecordName ) );
  infolist.push_back( TRunInformation( "RECORD SIZE", itostr( theRecordSize ) ) );
  infolist.push_back( TRunInformation( "RUN BEGIN", theRunBeginTime ) );
  infolist.push_back( TRunInformation( "RUN END", theRunEndTime ) );
  infolist.push_back( TRunInformation( "EVENTS", itostr( theNumberOfEvents ) ) );


  // I wish.
  infolist.push_back( TRunInformation( "TEMP. AVE. (C)", "***" ) );
  infolist.push_back( TRunInformation( "TEMP. MIN. (C)", "***" ) );
  infolist.push_back( TRunInformation( "TEMP. MAX. (C)", "***" ) );
  infolist.push_back( TRunInformation( "DARK AVE. (ADU)", "***" ) );
  infolist.push_back( TRunInformation( "DARK MIN. (ADU)", "***" ) );
  infolist.push_back( TRunInformation( "DARK MAX. (ADU)", "***" ) );
  infolist.push_back( TRunInformation( "SIGNAL AVE. (ADU)", "***" ) );
  infolist.push_back( TRunInformation( "SIGNAL MIN. (ADU)", "***" ) );
  infolist.push_back( TRunInformation( "SIGNAL MAX. (ADU)", "***" ) );
  infolist.push_back( TRunInformation( "H.O.C. AVE. (ADU)", "***" ) );
  // I wish.



  return( theRunInformationTable + infolist );
}
