// =====================================================================
//  $Id: St01SinglePixel.hh,v 1.2 2003/07/30 16:16:11 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: St01SinglePixel.hh,v $
//  Revision 1.2  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST01SINGLEPIEL_HH
#define __ST01SINGLEPIEL_HH

#include "Tglobals.h"

class St01SinglePixel
{

  protected:
    Tint theHorizontalID;
    Tint theVerticalID;
    Tdouble theSignal;
    Tdouble theDark;
    Tdouble theRms;

  public:
    St01SinglePixel( Tint h = 0, Tint v = 0, Tdouble signal = 0.0, Tdouble dark = 0.0, Tdouble rms = 0.0 );
    St01SinglePixel( const St01SinglePixel& right );
    ~St01SinglePixel();

  public:
    const St01SinglePixel& operator=( const St01SinglePixel& right );
    Tbool operator==( const St01SinglePixel& right ) const;
    Tbool operator!=( const St01SinglePixel& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const St01SinglePixel& right );
    friend Tistream& operator>>( Tistream& tis, St01SinglePixel& right );

  public:
    Tint GetHorizontalID() const;
    Tint GetVerticalID() const;
    Tdouble GetSignal() const;
    Tdouble GetDark() const;
    Tdouble GetRms() const;
    Tvoid SetHorizontalID( Tint id );
    Tvoid SetVerticalID( Tint id );
    Tvoid SetSignal( Tdouble signal );
    Tvoid SetDark( Tdouble dark );
    Tvoid SetRms( Tdouble rms );

};

inline Tint St01SinglePixel::GetHorizontalID() const
{
  return( theHorizontalID );
}

inline Tint St01SinglePixel::GetVerticalID() const
{
  return( theVerticalID );
}

inline Tdouble St01SinglePixel::GetSignal() const
{
  return( theSignal );
}

inline Tdouble St01SinglePixel::GetDark() const
{
  return( theDark );
}

inline Tdouble St01SinglePixel::GetRms() const
{
  return( theRms );
}

inline Tvoid St01SinglePixel::SetHorizontalID( Tint id )
{
  theHorizontalID = id;
  return;
}

inline Tvoid St01SinglePixel::SetVerticalID( Tint id )
{
  theVerticalID = id;
  return;
}

inline Tvoid St01SinglePixel::SetSignal( Tdouble signal )
{
  theSignal = signal;
  return;
}

inline Tvoid St01SinglePixel::SetDark( Tdouble dark )
{
  theDark = dark;
  return;
}

inline Tvoid St01SinglePixel::SetRms( Tdouble rms )
{
  theRms = rms;
  return;
}

#endif
