// =====================================================================
//  $Id: OFFpureplot.cc,v 1.2 2003/07/30 16:16:33 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: OFFpureplot.cc,v $
//  Revision 1.2  2003/07/30 16:16:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  Tstring ifname = argv[ 1 ];

  TApplication* theApplication = rootinit();
  TCanvas cv( "CVfadc", "Pentland MPX201A" );
  TH1D mpx201a( "mpx201a", "do nothing to data", 400, 0.0, 4096.0 );
  //mpx201a.SetFillColor( 45 );


  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TDataRecord record;
  TInputObjectFile ifile( ifname );
  while ( ( ifile >> record ) != 0 ) {
    TDataElement e;
    if ( record.FindDataElement( fadcidset, e ) ) {
      Tshort* data = e.GetShortData();
      Tint ndata = e.GetNumberOfPrimitives();
      for ( Tint i = 0; i < ndata; i ++ ) {
	mpx201a.Fill( data[ i ] );
      }
    } else {
      continue;
    }
  }

  cv.cd();
  mpx201a.Draw();
  theApplication -> Run();

  return( 0 );
}
