// =====================================================================
//  $Id: St02DarkDataSetInterface.hh,v 1.2 2003/07/30 16:16:34 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: St02DarkDataSetInterface.hh,v $
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST02SINGLEPIXELINTERFACE_HH
#define __ST02SINGLEPIXELINTERFACE_HH

#include "Tglobals.h"
#include "St02DarkDataSetList.hh"
#include "TEnvironmentVariableTable.hh"

class St02DarkDataSetInterface
{

  private:
    St02DarkDataSetList theDarkDataSetList;
    TEnvironmentVariableTable theEnvironmentVariableTable;
    Tint theXrayPeakCount;
    Tint theXrayPeakElectron;

  public:
    St02DarkDataSetInterface( const Tstring& rcfile );
    ~St02DarkDataSetInterface();

  public:
    const St02DarkDataSetList& GetDarkDataSetList() const;
    St02DarkDataSetList& GetDarkDataSetList();
    Tint GetXrayPeakCount() const;
    Tint GetXrayPeakElectron() const;
    Tvoid SetDarkDataSetList( const St02DarkDataSetList& list );
    Tvoid SetXrayPeakCount( Tint adc );
    Tvoid SetXrayPeakElectron( Tint e );

};

inline const St02DarkDataSetList& St02DarkDataSetInterface::GetDarkDataSetList() const
{
  return( theDarkDataSetList );
}

inline St02DarkDataSetList& St02DarkDataSetInterface::GetDarkDataSetList()
{
  return( theDarkDataSetList );
}

inline Tint St02DarkDataSetInterface::GetXrayPeakCount() const
{
  return( theXrayPeakCount );
}

inline Tint St02DarkDataSetInterface::GetXrayPeakElectron() const
{
  return( theXrayPeakElectron );
}

inline Tvoid St02DarkDataSetInterface::SetDarkDataSetList( const St02DarkDataSetList& list )
{
  theDarkDataSetList = list;
  return;
}

inline Tvoid St02DarkDataSetInterface::SetXrayPeakCount( Tint adc )
{
  theXrayPeakCount = adc;
  return;
}

inline Tvoid St02DarkDataSetInterface::SetXrayPeakElectron( Tint e )
{
  theXrayPeakElectron = e;
  return;
}

#endif
